(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: config_types.sml,v 1.4 2001/09/03 19:36:33 felix Exp $ *)

(*  This is the parse tree for the configuration file language.
*)

structure ConfigTypes =
struct

    datatype Section = 
	    SectServer of {
		parts:	SectionPart list,
		pos:	Common.SrcPos
		}

	|   SectNode of {
		path:	string,
		parts:	SectionPart list,
		pos:	Common.SrcPos
		}

	(*  This is for the contents of a .swerve file *)
	|   SectSwerve of {
		parts:	SectionPart list
		}

    and	    SectionPart = SectionPart of {
    		left:	string,
    		right:	Literal list,
		pos:	Common.SrcPos
		}

    and	    Literal =
		LitIsString of string * Common.SrcPos
	    |   LitIsInt of int * Common.SrcPos
end
