(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main =
struct
    fun toErr msg = TextIO.output(TextIO.stdErr, msg)


    datatype Message = 
	    MsgIsIncr of int
	|   MsgIsStop

    fun counter in_chan () =
    let
	fun loop count =
	(
	    case CML.recv in_chan of
	      MsgIsIncr n => loop (count + n)

	    | MsgIsStop =>
	    (
		print(concat["Count is ", Int.toString count, "\n"])
	    )
	)
    in
	loop 0
    end



    fun driver out_chan () =
    let
    in
	CML.send(out_chan, MsgIsIncr 3);
	CML.send(out_chan, MsgIsIncr ~1);
	CML.send(out_chan, MsgIsStop)
    end



    fun run() =
    let
	val chan: Message CML.chan = CML.channel()
	val d = CML.spawn (driver chan)
	val c = CML.spawn (counter chan)
    in
	CML.sync(CML.joinEvt d);
	CML.sync(CML.joinEvt c);
	()
    end



    fun main(arg0, argv) =
    let
    in
	RunCML.doit(run, NONE);
        OS.Process.success
    end
    handle
      x =>
    (
	toErr(concat["Uncaught exception: ", exnMessage x, " from\n"]);
	app (fn s => (print "\t"; print s; print "\n")) (SMLofNJ.exnHistory x);
	OS.Process.failure
    )

    val _ = SMLofNJ.exportFn("counter", main)
end



