(*  Copyright (c) 2001 Anthony L Shipman *)


(*  This creates a large number of threads that each wait on a time-out event.
    The time required to start each thread is reported.

*)

structure Main =
struct
    fun toErr msg = TextIO.output(TextIO.stdErr, msg)

    (*	The number of thousands of threads to spawn. *)
    val M = 5

    fun toTime n = Time.fromSeconds(LargeInt.fromInt n)



    fun thread n evt () =
    let
	fun report() = print(concat["Thread ", Int.toString n, " finishes\n"])
    in
	CML.sync(CML.wrap(evt, report))
    end


    (*	This models the behaviour of the web server which creates a time-out
	event and then spawns a thread to wait for it.
    *)
    fun spawner 0 = ()
    |   spawner n =
    let
	(*val evt = CML.atTimeEvt(Time.+(Time.now(), toTime(M * 5)))*)
	val evt = CML.timeOutEvt(toTime(M * 5))
	val name = concat["Thread ", Int.toString n]
    in
	Timing.timeIt name (fn() => ignore(CML.spawn (thread n evt)));
	spawner (n-1)
    end


    fun run() =
    let
	fun finish when = Timing.report()
    in
	ignore(RunCML.addCleaner("report", [RunCML.AtShutdown], finish));
	spawner (M * 1000)
    end



    fun main(arg0, argv) =
    let
    in
	RunCML.doit(run, NONE);
        OS.Process.success
    end
    handle
      x =>
    (
	toErr(concat["Uncaught exception: ", exnMessage x, " from\n"]);
	app (fn s => (print "\t"; print s; print "\n")) (SMLofNJ.exnHistory x);
	OS.Process.failure
    )

    val _ = SMLofNJ.exportFn("thr_scaling", main)
end


