(*  Copyright (c) 2001 Anthony L Shipman *)

structure Main=
struct

    fun main(arg0, argv) =
    let
	val cnt = word_count "the quick brown fox";
    in
	print(concat["Count = ", Int.toString cnt, "\n"]);
        OS.Process.success
    end


    and word_count text =
    let
	fun out_state []        count = count
	|   out_state (c::rest) count =
	(
	    if Char.isSpace c
	    then
		out_state rest count
	    else
		in_state rest count
	)

	and in_state []        count = count + 1
	|   in_state (c::rest) count =
	(
	    if Char.isSpace c
	    then
		out_state rest (count + 1)
	    else
		in_state rest count
	)
    in
	out_state (explode text) 0
    end


    val _ = SMLofNJ.exportFn("wordCnt", main)
end
