(*  Copyright (c) 2001 Anthony L Shipman *)

structure Main=
struct

    fun main(arg0, argv) =
    let
	val cnt = word_count "the quick brown fox";
    in
	print(concat["Count = ", Int.toString cnt, "\n"]);
        OS.Process.success
    end


    and word_count text =
    let
	datatype State = In | Out

	fun loop Out []        count = count

	|   loop Out (c::rest) count =
	(
	    if Char.isSpace c
	    then
		loop Out rest count
	    else
		loop In rest count
	)

	|   loop In []        count = count + 1

	|   loop In (c::rest) count =
	(
	    if Char.isSpace c
	    then
		loop Out rest (count + 1)
	    else
		loop In rest count
	)
    in
	loop Out (explode text) 0
    end


    val _ = SMLofNJ.exportFn("wordCnt2", main)
end
