(*  Copyright (c) 2001 Anthony L Shipman *)


structure Main=
struct

    fun toErr s = TextIO.output(TextIO.stdErr, s)

    structure F = Format

    fun test_format() =
    (
	F.formatf
	    "A decimal %d, some hex %#08x and some real %.4f\n"
	    print
	    [F.INT ~23, F.WORD 0wxbeef, F.REAL 3.14159265]
    )


    structure S = Scan

    fun test_scan() : unit =
    let
	val items = valOf(S.sscanf "%d %s %f" "123 abc 3.45")

	val display = ListFormat.fmt {
			init  = "[",
			sep   = " ",
			final = "]",
			fmt   = show_item
			} items
    in
	print display; print "\n"
    end


    and show_item (S.INT n)  = Int.toString n
    |   show_item (S.STR s)  = s
    |   show_item (S.REAL r) = Real.toString r
    |   show_item _          = "unknown"



    fun test_scan_io() =
    let
	val _ = print "Enter 3 integers\n"
    in
	case TextIO.scanStream (S.scanf "%d %d %d") TextIO.stdIn of
	  SOME items => (
	    print "got ";
	    print (ListFormat.listToString show_item items);
	    print "\n"
	    )

	| NONE => print "The reading failed\n"
    end



    fun main(arg0, argv) =
    (
	test_format();
	test_scan();
	test_scan_io();
	OS.Process.success
    )
    handle x =>
    (
	toErr(exnMessage x); toErr("\n");
	OS.Process.failure
    )

    val _ = SMLofNJ.exportFn("format", main)
end
