(*  Copyright (c) 2001 Anthony L Shipman *)

structure Main=
struct
    structure Map = IntRedBlackMap

    fun toErr s = TextIO.output(TextIO.stdErr, s)


    fun read_file file : int Map.map =
    let
	val istrm = TextIO.openIn file

	(*  Read a pair of ints on a line and loop.
	    Empty lines are ignored. Other junk is fatal.
	*)
	fun get_pairs map_in lnum =
	(
	    case TextIO.inputLine istrm of
	      "" => (TextIO.closeIn istrm; map_in)   (* eof *)

	    | line =>
	    let
		val tokens = String.tokens Char.isSpace line
	    in
		case map Int.fromString tokens of
		  [] => get_pairs map_in (lnum+1)

		| [SOME a, SOME b] =>
		      get_pairs (Map.insert(map_in, a, b)) (lnum+1)

		| _ => raise Fail (concat["Invalid data on line ",
				          Int.toString lnum])
	    end
	)
	handle x => (TextIO.closeIn istrm; raise x)

    in
	get_pairs Map.empty 1
    end


    and show_pairs pairs =
    let
	fun show (a, b) = print(concat[
	    Int.toString a, " => ", Int.toString b, "\n"])
    in
	Map.appi show pairs
    end


    fun main(arg0, argv) =
    (
        case argv of
	  [file] =>
	(
	    show_pairs(read_file file);
	    OS.Process.success
        )

	| _ =>
	(
	    print "Usage: intmap file\n";
	    OS.Process.failure
	)
    )
    handle x =>
    (
	toErr(exnMessage x); toErr("\n");
	OS.Process.failure
    )

    val _ = SMLofNJ.exportFn("intmap", main)
end
