(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: t_main.sml,v 1.3 2001/06/27 19:07:09 felix Exp $ *)

structure TestMain: sig end =
struct

    fun toErr s = TextIO.output(TextIO.stdErr, s)


    fun main(arg0, argv) =
    let
	fun run() =
	(
	    SignalMgr.init();	    (* required by OpenMgr *)
	    (* Log.setLevel Log.Debug; *)

	    print "=================================\n";
	    t_URL.run();

	    print "\n=================================\n";
	    t_Text.run();

	    print "\n=================================\n";
	    t_OpenMgr.run();

	    print "\n=================================\n";

	    if TestUtils.numFailures() = 0
	    then
		(print "All tests passed\n"; Common.success())
	    else
		(print "Tests failed\n"; Common.fail())
	)
	handle x =>
	    toErr(concat["Uncaught exception ", exnName x, ": ",exnMessage x, "\n"])
    in
	RunCML.doit(run, NONE)
    end

    val _ = SMLofNJ.exportFn("t_main", main)

end
