(*  Copyright (c) 2001 Anthony L Shipman *)

(* $Id: t_text.sml,v 1.3 2001/06/07 01:40:50 felix Exp $ *)

signature T_TEXT =
sig
    val run:	unit -> unit
end



structure t_Text: T_TEXT =
struct

    open TestUtils
    structure TF=TextFrag

(*------------------------------------------------------------------------------*)

    val t1 = TF.S "abc"
    val t2 = TF.S "def"
    val foxes = ["the", "quick", "brown", "fox"]
    val t3 = TF.L foxes
    val tx = TF.C [t1, TF.C [TF.WS, t2, TF.Nl, t3], TF.Empty]


    fun test1() = 
    (
	expectS ""	(TF.toString TF.UseLf TF.Empty)		"test1 empty";
	expectS "\n"	(TF.toString TF.UseLf TF.Nl)		"test1 lf";
	expectS "\r\n"	(TF.toString TF.UseCrLf TF.Nl)		"test1 crlf";
	expectS "abc"	(TF.toString TF.UseLf (TF.S "abc"))	"test1 abc";
	expectS "abcdef"(TF.toString TF.UseLf (TF.L ["abc", "def"])) "test1 list";

	expectS "abc def\nthequickbrownfox" (TF.toString TF.UseLf tx) "test1 txc";
	()
    )



    fun test2() = 
    let
	fun quote s = TF.L ["'", s, "'"]
    in
	expectS "'the''quick''brown''fox'" (TF.toString TF.UseLf (TF.lift quote foxes))
		"test2 lift";

	expectS "'the' 'quick' 'brown' 'fox'"
		(TF.toString TF.UseLf (TF.liftSep (TF.S " ") quote foxes))
		"test2 liftsep";
	()
    end


    fun test3() =
    (
	(TF.apply TF.UseLf print tx);
	print "\n";
	(TF.apply TF.UseCrLf print tx);
	print "\n"
    )


    fun test4() = 
    (
	expectI 0   (TF.length TF.UseLf TF.Empty)	"test4 empty";
	expectI 1   (TF.length TF.UseLf TF.Nl)		"test4 lf";
	expectI 2   (TF.length TF.UseCrLf TF.Nl)	"test4 crlf";
	expectI 3   (TF.length TF.UseLf (TF.S "abc"))	"test4 abc";
	expectI 6   (TF.length TF.UseLf (TF.L ["abc", "def"])) "test4 list";
	expectI 24  (TF.length TF.UseLf tx)		"test4 txc";
	()
    )


    fun run() =
    (
	print "Testing the Text Module\n";

	test1();
	test2();
	test3();
	test4();

	()
    )

(*------------------------------------------------------------------------------*)

end
