/*
 * Decompiled with CFR 0.152.
 */
package com.sap.dbtech.jdbc.translators;

import com.sap.dbtech.jdbc.translators.BinaryDataTranslator;
import com.sap.dbtech.jdbc.translators.ConversionExceptionSapDB;
import com.sap.dbtech.jdbc.translators.SQLParamController;
import com.sap.dbtech.util.StructuredMem;
import java.math.BigDecimal;
import java.sql.SQLException;
import java.util.Date;

class BooleanTranslator
extends BinaryDataTranslator {
    BooleanTranslator(int n, int n2, int n3, int n4, int n5, int n6, boolean bl, boolean bl2) {
        super(n, n2, n3, n4, n5, n6, bl, bl2);
    }

    public BigDecimal getBigDecimal(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        if (this.isNull(sQLParamController, structuredMem)) {
            return null;
        }
        boolean bl = this.getBoolean(sQLParamController, structuredMem);
        BigDecimal bigDecimal = bl ? new BigDecimal(1.0) : new BigDecimal(0.0);
        return bigDecimal;
    }

    public boolean getBoolean(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        boolean bl = false;
        if (!this.isNull(sQLParamController, structuredMem)) {
            byte by = structuredMem.getInt1(this.bufpos);
            bl = by != 0;
        }
        return bl;
    }

    public byte getByte(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getBoolean(sQLParamController, structuredMem) ? (byte)1 : 0;
    }

    public float getFloat(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getBoolean(sQLParamController, structuredMem) ? 1.0f : 0.0f;
    }

    public double getDouble(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getBoolean(sQLParamController, structuredMem) ? 1.0 : 0.0;
    }

    public Object getObject(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        if (this.isNull(sQLParamController, structuredMem)) {
            return null;
        }
        boolean bl = this.getBoolean(sQLParamController, structuredMem);
        Boolean bl2 = bl ? Boolean.TRUE : Boolean.FALSE;
        return bl2;
    }

    public int getInt(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getBoolean(sQLParamController, structuredMem) ? 1 : 0;
    }

    public long getLong(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getBoolean(sQLParamController, structuredMem) ? 1L : 0L;
    }

    public short getShort(SQLParamController sQLParamController, StructuredMem structuredMem) throws SQLException {
        return this.getBoolean(sQLParamController, structuredMem) ? (short)1 : 0;
    }

    public Object transBooleanForInput(boolean bl) {
        byte[] byArray = new byte[]{bl ? (byte)1 : 0};
        return byArray;
    }

    public Object transSpecificForInput(Object object) throws ConversionExceptionSapDB {
        Object object2 = null;
        if (object instanceof Boolean) {
            object2 = this.transBooleanForInput((Boolean)object);
        } else if (object instanceof Number) {
            int n = ((Number)object).intValue();
            object2 = n == 0 ? this.transBooleanForInput(false) : this.transBooleanForInput(true);
        } else if (object instanceof Date) {
            throw this.newSetException(object.getClass().getName());
        }
        return object2;
    }

    public Object transStringForInput(String string) {
        if (string == null) {
            return null;
        }
        Boolean bl = new Boolean(string);
        return this.transBooleanForInput(bl);
    }
}

