/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Reader;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.TitledBorder;
import proguard.ClassSpecification;
import proguard.Configuration;
import proguard.ConfigurationParser;
import proguard.ConfigurationWriter;
import proguard.KeepClassSpecification;
import proguard.ParseException;
import proguard.classfile.util.ClassUtil;
import proguard.gui.ClassPathPanel;
import proguard.gui.ClassSpecificationsPanel;
import proguard.gui.ExtensionFileFilter;
import proguard.gui.GUIResources;
import proguard.gui.KeepSpecificationsPanel;
import proguard.gui.OptimizationsDialog;
import proguard.gui.ProGuardRunnable;
import proguard.gui.ReTraceRunnable;
import proguard.gui.SwingUtil;
import proguard.gui.TabbedPane;
import proguard.gui.TextAreaOutputStream;
import proguard.gui.splash.ColorSprite;
import proguard.gui.splash.CompositeSprite;
import proguard.gui.splash.ConstantColor;
import proguard.gui.splash.ConstantDouble;
import proguard.gui.splash.ConstantFont;
import proguard.gui.splash.ConstantInt;
import proguard.gui.splash.ConstantString;
import proguard.gui.splash.FontSprite;
import proguard.gui.splash.LinearInt;
import proguard.gui.splash.LinearTiming;
import proguard.gui.splash.ShadowedSprite;
import proguard.gui.splash.SmoothTiming;
import proguard.gui.splash.SplashPanel;
import proguard.gui.splash.Sprite;
import proguard.gui.splash.TextSprite;
import proguard.gui.splash.TypeWriterString;
import proguard.util.ListUtil;

public class ProGuardGUI
extends JFrame {
    private static final String NO_SPLASH_OPTION = "-nosplash";
    private static final String TITLE_IMAGE_FILE = "vtitle.png";
    private static final String BOILERPLATE_CONFIGURATION = "boilerplate.pro";
    private static final String DEFAULT_CONFIGURATION = "default.pro";
    private static final String OPTIMIZATIONS_DEFAULT = "*";
    private static final String KEEP_ATTRIBUTE_DEFAULT = "Exceptions,InnerClasses,Signature,Deprecated,SourceFile,LineNumberTable,LocalVariable*Table,*Annotation*,Synthetic,EnclosingMethod";
    private static final String SOURCE_FILE_ATTRIBUTE_DEFAULT = "SourceFile";
    private static final String ADAPT_RESOURCE_FILE_NAMES_DEFAULT = "**.properties";
    private static final String ADAPT_RESOURCE_FILE_CONTENTS_DEFAULT = "**.properties,META-INF/MANIFEST.MF";
    private static final Border BORDER = BorderFactory.createEtchedBorder(0);
    static boolean systemOutRedirected;
    private final JFileChooser configurationChooser = new JFileChooser("");
    private final JFileChooser fileChooser = new JFileChooser("");
    private final SplashPanel splashPanel;
    private final ClassPathPanel programPanel = new ClassPathPanel(this, true);
    private final ClassPathPanel libraryPanel = new ClassPathPanel(this, false);
    private KeepClassSpecification[] boilerplateKeep;
    private final JCheckBox[] boilerplateKeepCheckBoxes;
    private final JTextField[] boilerplateKeepTextFields;
    private final KeepSpecificationsPanel additionalKeepPanel = new KeepSpecificationsPanel(this, true, false, false, false, false);
    private KeepClassSpecification[] boilerplateKeepNames;
    private final JCheckBox[] boilerplateKeepNamesCheckBoxes;
    private final JTextField[] boilerplateKeepNamesTextFields;
    private final KeepSpecificationsPanel additionalKeepNamesPanel = new KeepSpecificationsPanel(this, true, false, true, false, false);
    private ClassSpecification[] boilerplateNoSideEffectMethods;
    private final JCheckBox[] boilerplateNoSideEffectMethodCheckBoxes;
    private final ClassSpecificationsPanel additionalNoSideEffectsPanel = new ClassSpecificationsPanel(this, false);
    private final ClassSpecificationsPanel whyAreYouKeepingPanel = new ClassSpecificationsPanel(this, false);
    private final JCheckBox shrinkCheckBox = new JCheckBox(ProGuardGUI.msg("shrink"));
    private final JCheckBox printUsageCheckBox = new JCheckBox(ProGuardGUI.msg("printUsage"));
    private final JCheckBox optimizeCheckBox = new JCheckBox(ProGuardGUI.msg("optimize"));
    private final JCheckBox allowAccessModificationCheckBox = new JCheckBox(ProGuardGUI.msg("allowAccessModification"));
    private final JCheckBox mergeInterfacesAggressivelyCheckBox = new JCheckBox(ProGuardGUI.msg("mergeInterfacesAggressively"));
    private final JLabel optimizationsLabel = new JLabel(ProGuardGUI.msg("optimizations"));
    private final JLabel optimizationPassesLabel = new JLabel(ProGuardGUI.msg("optimizationPasses"));
    private final JSpinner optimizationPassesSpinner = new JSpinner(new SpinnerNumberModel(1, 1, 9, 1));
    private final JCheckBox obfuscateCheckBox = new JCheckBox(ProGuardGUI.msg("obfuscate"));
    private final JCheckBox printMappingCheckBox = new JCheckBox(ProGuardGUI.msg("printMapping"));
    private final JCheckBox applyMappingCheckBox = new JCheckBox(ProGuardGUI.msg("applyMapping"));
    private final JCheckBox obfuscationDictionaryCheckBox = new JCheckBox(ProGuardGUI.msg("obfuscationDictionary"));
    private final JCheckBox classObfuscationDictionaryCheckBox = new JCheckBox(ProGuardGUI.msg("classObfuscationDictionary"));
    private final JCheckBox packageObfuscationDictionaryCheckBox = new JCheckBox(ProGuardGUI.msg("packageObfuscationDictionary"));
    private final JCheckBox overloadAggressivelyCheckBox = new JCheckBox(ProGuardGUI.msg("overloadAggressively"));
    private final JCheckBox useUniqueClassMemberNamesCheckBox = new JCheckBox(ProGuardGUI.msg("useUniqueClassMemberNames"));
    private final JCheckBox useMixedCaseClassNamesCheckBox = new JCheckBox(ProGuardGUI.msg("useMixedCaseClassNames"));
    private final JCheckBox keepPackageNamesCheckBox = new JCheckBox(ProGuardGUI.msg("keepPackageNames"));
    private final JCheckBox flattenPackageHierarchyCheckBox = new JCheckBox(ProGuardGUI.msg("flattenPackageHierarchy"));
    private final JCheckBox repackageClassesCheckBox = new JCheckBox(ProGuardGUI.msg("repackageClasses"));
    private final JCheckBox keepAttributesCheckBox = new JCheckBox(ProGuardGUI.msg("keepAttributes"));
    private final JCheckBox newSourceFileAttributeCheckBox = new JCheckBox(ProGuardGUI.msg("renameSourceFileAttribute"));
    private final JCheckBox adaptClassStringsCheckBox = new JCheckBox(ProGuardGUI.msg("adaptClassStrings"));
    private final JCheckBox adaptResourceFileNamesCheckBox = new JCheckBox(ProGuardGUI.msg("adaptResourceFileNames"));
    private final JCheckBox adaptResourceFileContentsCheckBox = new JCheckBox(ProGuardGUI.msg("adaptResourceFileContents"));
    private final JCheckBox preverifyCheckBox = new JCheckBox(ProGuardGUI.msg("preverify"));
    private final JCheckBox microEditionCheckBox = new JCheckBox(ProGuardGUI.msg("microEdition"));
    private final JCheckBox targetCheckBox = new JCheckBox(ProGuardGUI.msg("target"));
    private final JComboBox targetComboBox = new JComboBox<Object>(ListUtil.commaSeparatedList((String)ProGuardGUI.msg("targets")).toArray());
    private final JCheckBox verboseCheckBox = new JCheckBox(ProGuardGUI.msg("verbose"));
    private final JCheckBox noteCheckBox = new JCheckBox(ProGuardGUI.msg("note"));
    private final JCheckBox warnCheckBox = new JCheckBox(ProGuardGUI.msg("warn"));
    private final JCheckBox ignoreWarningsCheckBox = new JCheckBox(ProGuardGUI.msg("ignoreWarnings"));
    private final JCheckBox skipNonPublicLibraryClassesCheckBox = new JCheckBox(ProGuardGUI.msg("skipNonPublicLibraryClasses"));
    private final JCheckBox skipNonPublicLibraryClassMembersCheckBox = new JCheckBox(ProGuardGUI.msg("skipNonPublicLibraryClassMembers"));
    private final JCheckBox keepDirectoriesCheckBox = new JCheckBox(ProGuardGUI.msg("keepDirectories"));
    private final JCheckBox forceProcessingCheckBox = new JCheckBox(ProGuardGUI.msg("forceProcessing"));
    private final JCheckBox printSeedsCheckBox = new JCheckBox(ProGuardGUI.msg("printSeeds"));
    private final JCheckBox printConfigurationCheckBox = new JCheckBox(ProGuardGUI.msg("printConfiguration"));
    private final JCheckBox dumpCheckBox = new JCheckBox(ProGuardGUI.msg("dump"));
    private final JTextField printUsageTextField = new JTextField(40);
    private final JTextField optimizationsTextField = new JTextField(40);
    private final JTextField printMappingTextField = new JTextField(40);
    private final JTextField applyMappingTextField = new JTextField(40);
    private final JTextField obfuscationDictionaryTextField = new JTextField(40);
    private final JTextField classObfuscationDictionaryTextField = new JTextField(40);
    private final JTextField packageObfuscationDictionaryTextField = new JTextField(40);
    private final JTextField keepPackageNamesTextField = new JTextField(40);
    private final JTextField flattenPackageHierarchyTextField = new JTextField(40);
    private final JTextField repackageClassesTextField = new JTextField(40);
    private final JTextField keepAttributesTextField = new JTextField(40);
    private final JTextField newSourceFileAttributeTextField = new JTextField(40);
    private final JTextField adaptClassStringsTextField = new JTextField(40);
    private final JTextField adaptResourceFileNamesTextField = new JTextField(40);
    private final JTextField adaptResourceFileContentsTextField = new JTextField(40);
    private final JTextField noteTextField = new JTextField(40);
    private final JTextField warnTextField = new JTextField(40);
    private final JTextField keepDirectoriesTextField = new JTextField(40);
    private final JTextField printSeedsTextField = new JTextField(40);
    private final JTextField printConfigurationTextField = new JTextField(40);
    private final JTextField dumpTextField = new JTextField(40);
    private final JTextArea consoleTextArea = new JTextArea(ProGuardGUI.msg("processingInfo"), 3, 40);
    private final JCheckBox reTraceVerboseCheckBox = new JCheckBox(ProGuardGUI.msg("verbose"));
    private final JTextField reTraceMappingTextField = new JTextField(40);
    private final JTextArea stackTraceTextArea = new JTextArea(3, 40);
    private final JTextArea reTraceTextArea = new JTextArea(ProGuardGUI.msg("reTraceInfo"), 3, 40);

    public ProGuardGUI() {
        this.setTitle("ProGuard");
        this.setDefaultCloseOperation(3);
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.anchor = 17;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints4 = new GridBagConstraints();
        gridBagConstraints4.gridwidth = 0;
        gridBagConstraints4.fill = 2;
        gridBagConstraints4.weightx = 1.0;
        gridBagConstraints4.anchor = 17;
        gridBagConstraints4.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints5 = new GridBagConstraints();
        gridBagConstraints5.gridwidth = 0;
        gridBagConstraints5.fill = 1;
        gridBagConstraints5.weightx = 1.0;
        gridBagConstraints5.weighty = 0.02;
        gridBagConstraints5.anchor = 18;
        GridBagConstraints gridBagConstraints6 = new GridBagConstraints();
        gridBagConstraints6.gridwidth = 0;
        gridBagConstraints6.fill = 0;
        gridBagConstraints6.weightx = 1.0;
        gridBagConstraints6.weighty = 0.01;
        gridBagConstraints6.anchor = 10;
        gridBagConstraints6.insets = new Insets(20, 40, 20, 40);
        GridBagConstraints gridBagConstraints7 = new GridBagConstraints();
        gridBagConstraints7.gridwidth = 0;
        gridBagConstraints7.fill = 2;
        gridBagConstraints7.weightx = 1.0;
        gridBagConstraints7.anchor = 18;
        gridBagConstraints7.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints8 = new GridBagConstraints();
        gridBagConstraints8.gridwidth = 0;
        gridBagConstraints8.fill = 1;
        gridBagConstraints8.weightx = 1.0;
        gridBagConstraints8.weighty = 1.0;
        gridBagConstraints8.anchor = 18;
        gridBagConstraints8.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints9 = new GridBagConstraints();
        gridBagConstraints9.fill = 1;
        gridBagConstraints9.weightx = 0.01;
        gridBagConstraints9.weighty = 0.01;
        gridBagConstraints9.anchor = 18;
        gridBagConstraints9.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints10 = new GridBagConstraints();
        gridBagConstraints10.anchor = 14;
        gridBagConstraints10.insets = new Insets(2, 2, 4, 6);
        gridBagConstraints10.ipadx = 10;
        gridBagConstraints10.ipady = 2;
        GridBagConstraints gridBagConstraints11 = new GridBagConstraints();
        gridBagConstraints11.gridwidth = 0;
        gridBagConstraints11.anchor = 14;
        gridBagConstraints11.insets = gridBagConstraints10.insets;
        gridBagConstraints11.ipadx = gridBagConstraints10.ipadx;
        gridBagConstraints11.ipady = gridBagConstraints10.ipady;
        if (System.getProperty("os.name").toLowerCase().startsWith("mac os x")) {
            gridBagConstraints11.insets = new Insets(2, 2, 4, 22);
        }
        GridBagLayout gridBagLayout = new GridBagLayout();
        this.configurationChooser.addChoosableFileFilter(new ExtensionFileFilter(ProGuardGUI.msg("proExtension"), new String[]{".pro"}));
        CompositeSprite compositeSprite = new CompositeSprite(new Sprite[]{new ColorSprite(new ConstantColor(Color.gray), new FontSprite(new ConstantFont(new Font("sansserif", 1, 90)), new TextSprite(new ConstantString("ProGuard"), new ConstantInt(160), new LinearInt(-10, 120, new SmoothTiming(500L, 1000L))))), new ColorSprite(new ConstantColor(Color.white), new FontSprite(new ConstantFont(new Font("sansserif", 1, 45)), new ShadowedSprite(new ConstantInt(3), new ConstantInt(3), new ConstantDouble(0.4), new ConstantInt(1), new CompositeSprite(new Sprite[]{new TextSprite(new ConstantString(ProGuardGUI.msg("shrinking")), new LinearInt(1000, 60, new SmoothTiming(1000L, 2000L)), new ConstantInt(70)), new TextSprite(new ConstantString(ProGuardGUI.msg("optimization")), new LinearInt(1000, 400, new SmoothTiming(1500L, 2500L)), new ConstantInt(60)), new TextSprite(new ConstantString(ProGuardGUI.msg("obfuscation")), new LinearInt(1000, 10, new SmoothTiming(2000L, 3000L)), new ConstantInt(145)), new TextSprite(new ConstantString(ProGuardGUI.msg("preverification")), new LinearInt(1000, 350, new SmoothTiming(2500L, 3500L)), new ConstantInt(140)), new FontSprite(new ConstantFont(new Font("sansserif", 1, 30)), new TextSprite(new TypeWriterString(ProGuardGUI.msg("developed"), new LinearTiming(3500L, 5500L)), new ConstantInt(250), new ConstantInt(200)))}))))});
        this.splashPanel = new SplashPanel(compositeSprite, 0.5, 5500L);
        this.splashPanel.setPreferredSize(new Dimension(0, 200));
        JTextArea jTextArea = new JTextArea(ProGuardGUI.msg("proGuardInfo"), 18, 50);
        jTextArea.setOpaque(false);
        jTextArea.setEditable(false);
        jTextArea.setLineWrap(true);
        jTextArea.setWrapStyleWord(true);
        jTextArea.setPreferredSize(new Dimension(0, 0));
        jTextArea.setBorder(new EmptyBorder(20, 20, 20, 20));
        this.addBorder(jTextArea, "welcome");
        JPanel jPanel = new JPanel(gridBagLayout);
        jPanel.add((Component)this.splashPanel, gridBagConstraints5);
        jPanel.add((Component)jTextArea, gridBagConstraints6);
        this.programPanel.addCopyToPanelButton("moveToLibraries", "moveToLibrariesTip", this.libraryPanel);
        this.libraryPanel.addCopyToPanelButton("moveToProgram", "moveToProgramTip", this.programPanel);
        ArrayList arrayList = new ArrayList();
        arrayList.addAll(this.programPanel.getButtons());
        arrayList.addAll(this.libraryPanel.getButtons());
        this.setCommonPreferredSize(arrayList);
        this.addBorder(this.programPanel, "programJars");
        this.addBorder(this.libraryPanel, "libraryJars");
        JPanel jPanel2 = new JPanel(gridBagLayout);
        jPanel2.add((Component)ProGuardGUI.tip(this.programPanel, "programJarsTip"), gridBagConstraints8);
        jPanel2.add((Component)ProGuardGUI.tip(this.libraryPanel, "libraryJarsTip"), gridBagConstraints8);
        this.loadBoilerplateConfiguration();
        this.boilerplateKeepCheckBoxes = new JCheckBox[this.boilerplateKeep.length];
        this.boilerplateKeepTextFields = new JTextField[this.boilerplateKeep.length];
        JButton jButton = this.createBrowseButton(this.printUsageTextField, ProGuardGUI.msg("selectUsageFile"));
        JPanel jPanel3 = new JPanel(gridBagLayout);
        this.addBorder(jPanel3, "options");
        jPanel3.add((Component)ProGuardGUI.tip(this.shrinkCheckBox, "shrinkTip"), gridBagConstraints4);
        jPanel3.add((Component)ProGuardGUI.tip(this.printUsageCheckBox, "printUsageTip"), gridBagConstraints);
        jPanel3.add((Component)ProGuardGUI.tip(this.printUsageTextField, "outputFileTip"), gridBagConstraints2);
        jPanel3.add((Component)ProGuardGUI.tip(jButton, "selectUsageFile"), gridBagConstraints3);
        JPanel jPanel4 = new JPanel(gridBagLayout);
        jPanel4.add((Component)jPanel3, gridBagConstraints7);
        this.addClassSpecifications(this.extractClassSpecifications(this.boilerplateKeep), jPanel4, this.boilerplateKeepCheckBoxes, this.boilerplateKeepTextFields);
        this.addBorder(this.additionalKeepPanel, "keepAdditional");
        jPanel4.add((Component)ProGuardGUI.tip(this.additionalKeepPanel, "keepAdditionalTip"), gridBagConstraints8);
        this.boilerplateKeepNamesCheckBoxes = new JCheckBox[this.boilerplateKeepNames.length];
        this.boilerplateKeepNamesTextFields = new JTextField[this.boilerplateKeepNames.length];
        JButton jButton2 = this.createBrowseButton(this.printMappingTextField, ProGuardGUI.msg("selectPrintMappingFile"));
        JButton jButton3 = this.createBrowseButton(this.applyMappingTextField, ProGuardGUI.msg("selectApplyMappingFile"));
        JButton jButton4 = this.createBrowseButton(this.obfuscationDictionaryTextField, ProGuardGUI.msg("selectObfuscationDictionaryFile"));
        JButton jButton5 = this.createBrowseButton(this.classObfuscationDictionaryTextField, ProGuardGUI.msg("selectObfuscationDictionaryFile"));
        JButton jButton6 = this.createBrowseButton(this.packageObfuscationDictionaryTextField, ProGuardGUI.msg("selectObfuscationDictionaryFile"));
        JPanel jPanel5 = new JPanel(gridBagLayout);
        this.addBorder(jPanel5, "options");
        jPanel5.add((Component)ProGuardGUI.tip(this.obfuscateCheckBox, "obfuscateTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.printMappingCheckBox, "printMappingTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.printMappingTextField, "outputFileTip"), gridBagConstraints2);
        jPanel5.add((Component)ProGuardGUI.tip(jButton2, "selectPrintMappingFile"), gridBagConstraints3);
        jPanel5.add((Component)ProGuardGUI.tip(this.applyMappingCheckBox, "applyMappingTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.applyMappingTextField, "inputFileTip"), gridBagConstraints2);
        jPanel5.add((Component)ProGuardGUI.tip(jButton3, "selectApplyMappingFile"), gridBagConstraints3);
        jPanel5.add((Component)ProGuardGUI.tip(this.obfuscationDictionaryCheckBox, "obfuscationDictionaryTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.obfuscationDictionaryTextField, "inputFileTip"), gridBagConstraints2);
        jPanel5.add((Component)ProGuardGUI.tip(jButton4, "selectObfuscationDictionaryFile"), gridBagConstraints3);
        jPanel5.add((Component)ProGuardGUI.tip(this.classObfuscationDictionaryCheckBox, "classObfuscationDictionaryTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.classObfuscationDictionaryTextField, "inputFileTip"), gridBagConstraints2);
        jPanel5.add((Component)ProGuardGUI.tip(jButton5, "selectObfuscationDictionaryFile"), gridBagConstraints3);
        jPanel5.add((Component)ProGuardGUI.tip(this.packageObfuscationDictionaryCheckBox, "packageObfuscationDictionaryTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.packageObfuscationDictionaryTextField, "inputFileTip"), gridBagConstraints2);
        jPanel5.add((Component)ProGuardGUI.tip(jButton6, "selectObfuscationDictionaryFile"), gridBagConstraints3);
        jPanel5.add((Component)ProGuardGUI.tip(this.overloadAggressivelyCheckBox, "overloadAggressivelyTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.useUniqueClassMemberNamesCheckBox, "useUniqueClassMemberNamesTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.useMixedCaseClassNamesCheckBox, "useMixedCaseClassNamesTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.keepPackageNamesCheckBox, "keepPackageNamesTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.keepPackageNamesTextField, "packageNamesTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.flattenPackageHierarchyCheckBox, "flattenPackageHierarchyTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.flattenPackageHierarchyTextField, "packageTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.repackageClassesCheckBox, "repackageClassesTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.repackageClassesTextField, "packageTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.keepAttributesCheckBox, "keepAttributesTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.keepAttributesTextField, "attributesTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.newSourceFileAttributeCheckBox, "renameSourceFileAttributeTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.newSourceFileAttributeTextField, "sourceFileAttributeTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.adaptClassStringsCheckBox, "adaptClassStringsTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.adaptClassStringsTextField, "classNamesTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.adaptResourceFileNamesCheckBox, "adaptResourceFileNamesTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.adaptResourceFileNamesTextField, "fileNameFilterTip"), gridBagConstraints4);
        jPanel5.add((Component)ProGuardGUI.tip(this.adaptResourceFileContentsCheckBox, "adaptResourceFileContentsTip"), gridBagConstraints);
        jPanel5.add((Component)ProGuardGUI.tip(this.adaptResourceFileContentsTextField, "fileNameFilterTip"), gridBagConstraints4);
        JPanel jPanel6 = new JPanel(gridBagLayout);
        jPanel6.add((Component)jPanel5, gridBagConstraints7);
        this.addClassSpecifications(this.extractClassSpecifications(this.boilerplateKeepNames), jPanel6, this.boilerplateKeepNamesCheckBoxes, this.boilerplateKeepNamesTextFields);
        this.addBorder(this.additionalKeepNamesPanel, "keepNamesAdditional");
        jPanel6.add((Component)ProGuardGUI.tip(this.additionalKeepNamesPanel, "keepNamesAdditionalTip"), gridBagConstraints8);
        this.boilerplateNoSideEffectMethodCheckBoxes = new JCheckBox[this.boilerplateNoSideEffectMethods.length];
        JPanel jPanel7 = new JPanel(gridBagLayout);
        this.addBorder(jPanel7, "options");
        JButton jButton7 = this.createOptimizationsButton(this.optimizationsTextField);
        jPanel7.add((Component)ProGuardGUI.tip(this.optimizeCheckBox, "optimizeTip"), gridBagConstraints4);
        jPanel7.add((Component)ProGuardGUI.tip(this.allowAccessModificationCheckBox, "allowAccessModificationTip"), gridBagConstraints4);
        jPanel7.add((Component)ProGuardGUI.tip(this.mergeInterfacesAggressivelyCheckBox, "mergeInterfacesAggressivelyTip"), gridBagConstraints4);
        jPanel7.add((Component)ProGuardGUI.tip(this.optimizationsLabel, "optimizationsTip"), gridBagConstraints);
        jPanel7.add((Component)ProGuardGUI.tip(this.optimizationsTextField, "optimizationsFilterTip"), gridBagConstraints2);
        jPanel7.add((Component)ProGuardGUI.tip(jButton7, "optimizationsSelectTip"), gridBagConstraints3);
        jPanel7.add((Component)ProGuardGUI.tip(this.optimizationPassesLabel, "optimizationPassesTip"), gridBagConstraints);
        jPanel7.add((Component)ProGuardGUI.tip(this.optimizationPassesSpinner, "optimizationPassesTip"), gridBagConstraints3);
        JPanel jPanel8 = new JPanel(gridBagLayout);
        jPanel8.add((Component)jPanel7, gridBagConstraints7);
        this.addClassSpecifications(this.boilerplateNoSideEffectMethods, jPanel8, this.boilerplateNoSideEffectMethodCheckBoxes, null);
        this.addBorder(this.additionalNoSideEffectsPanel, "assumeNoSideEffectsAdditional");
        jPanel8.add((Component)ProGuardGUI.tip(this.additionalNoSideEffectsPanel, "assumeNoSideEffectsAdditionalTip"), gridBagConstraints8);
        JPanel jPanel9 = new JPanel(gridBagLayout);
        this.addBorder(jPanel9, "preverificationAndTargeting");
        jPanel9.add((Component)ProGuardGUI.tip(this.preverifyCheckBox, "preverifyTip"), gridBagConstraints4);
        jPanel9.add((Component)ProGuardGUI.tip(this.microEditionCheckBox, "microEditionTip"), gridBagConstraints4);
        jPanel9.add((Component)ProGuardGUI.tip(this.targetCheckBox, "targetTip"), gridBagConstraints);
        jPanel9.add((Component)ProGuardGUI.tip(this.targetComboBox, "targetTip"), gridBagConstraints3);
        JButton jButton8 = this.createBrowseButton(this.printSeedsTextField, ProGuardGUI.msg("selectSeedsFile"));
        JButton jButton9 = this.createBrowseButton(this.printConfigurationTextField, ProGuardGUI.msg("selectConfigurationFile"));
        JButton jButton10 = this.createBrowseButton(this.dumpTextField, ProGuardGUI.msg("selectDumpFile"));
        this.targetComboBox.setSelectedIndex(this.targetComboBox.getItemCount() - 1);
        JPanel jPanel10 = new JPanel(gridBagLayout);
        this.addBorder(jPanel10, "consistencyAndCorrectness");
        jPanel10.add((Component)ProGuardGUI.tip(this.verboseCheckBox, "verboseTip"), gridBagConstraints4);
        jPanel10.add((Component)ProGuardGUI.tip(this.noteCheckBox, "noteTip"), gridBagConstraints);
        jPanel10.add((Component)ProGuardGUI.tip(this.noteTextField, "noteFilterTip"), gridBagConstraints4);
        jPanel10.add((Component)ProGuardGUI.tip(this.warnCheckBox, "warnTip"), gridBagConstraints);
        jPanel10.add((Component)ProGuardGUI.tip(this.warnTextField, "warnFilterTip"), gridBagConstraints4);
        jPanel10.add((Component)ProGuardGUI.tip(this.ignoreWarningsCheckBox, "ignoreWarningsTip"), gridBagConstraints4);
        jPanel10.add((Component)ProGuardGUI.tip(this.skipNonPublicLibraryClassesCheckBox, "skipNonPublicLibraryClassesTip"), gridBagConstraints4);
        jPanel10.add((Component)ProGuardGUI.tip(this.skipNonPublicLibraryClassMembersCheckBox, "skipNonPublicLibraryClassMembersTip"), gridBagConstraints4);
        jPanel10.add((Component)ProGuardGUI.tip(this.keepDirectoriesCheckBox, "keepDirectoriesTip"), gridBagConstraints);
        jPanel10.add((Component)ProGuardGUI.tip(this.keepDirectoriesTextField, "directoriesTip"), gridBagConstraints4);
        jPanel10.add((Component)ProGuardGUI.tip(this.forceProcessingCheckBox, "forceProcessingTip"), gridBagConstraints4);
        jPanel10.add((Component)ProGuardGUI.tip(this.printSeedsCheckBox, "printSeedsTip"), gridBagConstraints);
        jPanel10.add((Component)ProGuardGUI.tip(this.printSeedsTextField, "outputFileTip"), gridBagConstraints2);
        jPanel10.add((Component)ProGuardGUI.tip(jButton8, "selectSeedsFile"), gridBagConstraints3);
        jPanel10.add((Component)ProGuardGUI.tip(this.printConfigurationCheckBox, "printConfigurationTip"), gridBagConstraints);
        jPanel10.add((Component)ProGuardGUI.tip(this.printConfigurationTextField, "outputFileTip"), gridBagConstraints2);
        jPanel10.add((Component)ProGuardGUI.tip(jButton9, "selectConfigurationFile"), gridBagConstraints3);
        jPanel10.add((Component)ProGuardGUI.tip(this.dumpCheckBox, "dumpTip"), gridBagConstraints);
        jPanel10.add((Component)ProGuardGUI.tip(this.dumpTextField, "outputFileTip"), gridBagConstraints2);
        jPanel10.add((Component)ProGuardGUI.tip(jButton10, "selectDumpFile"), gridBagConstraints3);
        this.setCommonPreferredSize(Arrays.asList(this.printMappingCheckBox, this.applyMappingCheckBox, this.flattenPackageHierarchyCheckBox, this.repackageClassesCheckBox, this.newSourceFileAttributeCheckBox));
        JPanel jPanel11 = new JPanel(gridBagLayout);
        jPanel11.add((Component)jPanel9, gridBagConstraints7);
        jPanel11.add((Component)jPanel10, gridBagConstraints7);
        this.addBorder(this.whyAreYouKeepingPanel, "whyAreYouKeeping");
        jPanel11.add((Component)ProGuardGUI.tip(this.whyAreYouKeepingPanel, "whyAreYouKeepingTip"), gridBagConstraints8);
        this.consoleTextArea.setOpaque(false);
        this.consoleTextArea.setEditable(false);
        this.consoleTextArea.setLineWrap(false);
        this.consoleTextArea.setWrapStyleWord(false);
        JScrollPane jScrollPane = new JScrollPane(this.consoleTextArea);
        jScrollPane.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.addBorder(jScrollPane, "processingConsole");
        JPanel jPanel12 = new JPanel(gridBagLayout);
        jPanel12.add((Component)jScrollPane, gridBagConstraints8);
        JButton jButton11 = new JButton(ProGuardGUI.msg("loadConfiguration"));
        jButton11.addActionListener(new MyLoadConfigurationActionListener());
        JButton jButton12 = new JButton(ProGuardGUI.msg("viewConfiguration"));
        jButton12.addActionListener(new MyViewConfigurationActionListener());
        JButton jButton13 = new JButton(ProGuardGUI.msg("saveConfiguration"));
        jButton13.addActionListener(new MySaveConfigurationActionListener());
        JButton jButton14 = new JButton(ProGuardGUI.msg("process"));
        jButton14.addActionListener(new MyProcessActionListener());
        JPanel jPanel13 = new JPanel(gridBagLayout);
        this.addBorder(jPanel13, "reTraceSettings");
        JButton jButton15 = this.createBrowseButton(this.reTraceMappingTextField, ProGuardGUI.msg("selectApplyMappingFile"));
        JLabel jLabel = new JLabel(ProGuardGUI.msg("mappingFile"));
        jLabel.setForeground(this.reTraceVerboseCheckBox.getForeground());
        jPanel13.add((Component)ProGuardGUI.tip(this.reTraceVerboseCheckBox, "verboseTip"), gridBagConstraints4);
        jPanel13.add((Component)ProGuardGUI.tip(jLabel, "mappingFileTip"), gridBagConstraints);
        jPanel13.add((Component)ProGuardGUI.tip(this.reTraceMappingTextField, "inputFileTip"), gridBagConstraints2);
        jPanel13.add((Component)ProGuardGUI.tip(jButton15, "selectApplyMappingFile"), gridBagConstraints3);
        this.stackTraceTextArea.setOpaque(true);
        this.stackTraceTextArea.setEditable(true);
        this.stackTraceTextArea.setLineWrap(false);
        this.stackTraceTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane2 = new JScrollPane(this.stackTraceTextArea);
        this.addBorder(jScrollPane2, "obfuscatedStackTrace");
        this.reTraceTextArea.setOpaque(false);
        this.reTraceTextArea.setEditable(false);
        this.reTraceTextArea.setLineWrap(true);
        this.reTraceTextArea.setWrapStyleWord(true);
        JScrollPane jScrollPane3 = new JScrollPane(this.reTraceTextArea);
        jScrollPane3.setBorder(new EmptyBorder(1, 1, 1, 1));
        this.addBorder(jScrollPane3, "deobfuscatedStackTrace");
        JPanel jPanel14 = new JPanel(gridBagLayout);
        jPanel14.add((Component)jPanel13, gridBagConstraints7);
        jPanel14.add((Component)ProGuardGUI.tip(jScrollPane2, "obfuscatedStackTraceTip"), gridBagConstraints7);
        jPanel14.add((Component)jScrollPane3, gridBagConstraints8);
        JButton jButton16 = new JButton(ProGuardGUI.msg("loadStackTrace"));
        jButton16.addActionListener(new MyLoadStackTraceActionListener());
        JButton jButton17 = new JButton(ProGuardGUI.msg("reTrace"));
        jButton17.addActionListener(new MyReTraceActionListener());
        TabbedPane tabbedPane = new TabbedPane();
        tabbedPane.add(ProGuardGUI.msg("proGuardTab"), jPanel);
        tabbedPane.add(ProGuardGUI.msg("inputOutputTab"), jPanel2);
        tabbedPane.add(ProGuardGUI.msg("shrinkingTab"), jPanel4);
        tabbedPane.add(ProGuardGUI.msg("obfuscationTab"), jPanel6);
        tabbedPane.add(ProGuardGUI.msg("optimizationTab"), jPanel8);
        tabbedPane.add(ProGuardGUI.msg("informationTab"), jPanel11);
        tabbedPane.add(ProGuardGUI.msg("processTab"), jPanel12);
        tabbedPane.add(ProGuardGUI.msg("reTraceTab"), jPanel14);
        tabbedPane.addImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource(TITLE_IMAGE_FILE)));
        jPanel.add(Box.createGlue(), gridBagConstraints9);
        jPanel.add((Component)ProGuardGUI.tip(jButton11, "loadConfigurationTip"), gridBagConstraints10);
        jPanel.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel2.add(Box.createGlue(), gridBagConstraints9);
        jPanel2.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel2.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel4.add(Box.createGlue(), gridBagConstraints9);
        jPanel4.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel4.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel6.add(Box.createGlue(), gridBagConstraints9);
        jPanel6.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel6.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel8.add(Box.createGlue(), gridBagConstraints9);
        jPanel8.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel8.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel11.add(Box.createGlue(), gridBagConstraints9);
        jPanel11.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel11.add((Component)this.createNextButton(tabbedPane), gridBagConstraints11);
        jPanel12.add(Box.createGlue(), gridBagConstraints9);
        jPanel12.add((Component)this.createPreviousButton(tabbedPane), gridBagConstraints10);
        jPanel12.add((Component)ProGuardGUI.tip(jButton12, "viewConfigurationTip"), gridBagConstraints10);
        jPanel12.add((Component)ProGuardGUI.tip(jButton13, "saveConfigurationTip"), gridBagConstraints10);
        jPanel12.add((Component)ProGuardGUI.tip(jButton14, "processTip"), gridBagConstraints11);
        jPanel14.add(Box.createGlue(), gridBagConstraints9);
        jPanel14.add((Component)ProGuardGUI.tip(jButton16, "loadStackTraceTip"), gridBagConstraints10);
        jPanel14.add((Component)ProGuardGUI.tip(jButton17, "reTraceTip"), gridBagConstraints11);
        this.loadConfiguration(this.getClass().getResource(DEFAULT_CONFIGURATION));
        this.getContentPane().add(tabbedPane);
    }

    public void startSplash() {
        this.splashPanel.start();
    }

    public void skipSplash() {
        this.splashPanel.stop();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadBoilerplateConfiguration() {
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(this.getClass().getResource(BOILERPLATE_CONFIGURATION));
            Configuration configuration = new Configuration();
            try {
                configurationParser.parse(configuration);
                this.boilerplateKeep = this.extractKeepSpecifications(configuration.keep, false, false);
                this.boilerplateKeepNames = this.extractKeepSpecifications(configuration.keep, true, false);
                this.boilerplateNoSideEffectMethods = new ClassSpecification[configuration.assumeNoSideEffects.size()];
                configuration.assumeNoSideEffects.toArray(this.boilerplateNoSideEffectMethods);
            }
            finally {
                configurationParser.close();
            }
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
    }

    private KeepClassSpecification[] extractKeepSpecifications(List list, boolean bl, boolean bl2) {
        ArrayList<KeepClassSpecification> arrayList = new ArrayList<KeepClassSpecification>();
        for (int i = 0; i < list.size(); ++i) {
            KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
            if (keepClassSpecification.allowShrinking != bl || keepClassSpecification.allowObfuscation != bl2) continue;
            arrayList.add(keepClassSpecification);
        }
        KeepClassSpecification[] keepClassSpecificationArray = new KeepClassSpecification[arrayList.size()];
        arrayList.toArray(keepClassSpecificationArray);
        return keepClassSpecificationArray;
    }

    private ClassSpecification[] extractClassSpecifications(KeepClassSpecification[] keepClassSpecificationArray) {
        ClassSpecification[] classSpecificationArray = new ClassSpecification[keepClassSpecificationArray.length];
        for (int i = 0; i < classSpecificationArray.length; ++i) {
            classSpecificationArray[i] = keepClassSpecificationArray[i];
        }
        return classSpecificationArray;
    }

    private void addClassSpecifications(ClassSpecification[] classSpecificationArray, JPanel jPanel, JCheckBox[] jCheckBoxArray, JTextField[] jTextFieldArray) {
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.anchor = 17;
        gridBagConstraints.insets = new Insets(0, 4, 0, 4);
        GridBagConstraints gridBagConstraints2 = new GridBagConstraints();
        gridBagConstraints2.gridwidth = 0;
        gridBagConstraints2.fill = 2;
        gridBagConstraints2.weightx = 1.0;
        gridBagConstraints2.anchor = 17;
        gridBagConstraints2.insets = gridBagConstraints.insets;
        GridBagConstraints gridBagConstraints3 = new GridBagConstraints();
        gridBagConstraints3.gridwidth = 0;
        gridBagConstraints3.fill = 2;
        gridBagConstraints3.weightx = 1.0;
        gridBagConstraints3.anchor = 18;
        gridBagConstraints3.insets = gridBagConstraints.insets;
        GridBagLayout gridBagLayout = new GridBagLayout();
        String string = null;
        JPanel jPanel2 = null;
        for (int i = 0; i < classSpecificationArray.length; ++i) {
            String string2 = classSpecificationArray[i].comments;
            int n = string2.indexOf(45);
            int n2 = string2.indexOf(46, n);
            String string3 = string2.substring(0, n).trim();
            String string4 = string2.substring(n + 1, n2).replace('_', '.').trim();
            String string5 = string2.substring(n2 + 1);
            if (jPanel2 == null || !string3.equals(string)) {
                jPanel2 = new JPanel(gridBagLayout);
                jPanel2.setBorder(BorderFactory.createTitledBorder(BORDER, string3));
                jPanel.add((Component)jPanel2, gridBagConstraints3);
                string = string3;
            }
            JCheckBox jCheckBox = new JCheckBox(string4);
            jCheckBox.setToolTipText(string5);
            jCheckBoxArray[i] = jCheckBox;
            jPanel2.add((Component)jCheckBox, jTextFieldArray != null ? gridBagConstraints : gridBagConstraints2);
            if (jTextFieldArray == null) continue;
            jTextFieldArray[i] = new JTextField(40);
            jPanel2.add((Component)ProGuardGUI.tip(jTextFieldArray[i], "classNamesTip"), gridBagConstraints2);
        }
    }

    private void addBorder(JComponent jComponent, String string) {
        Border border = jComponent.getBorder();
        TitledBorder titledBorder = BorderFactory.createTitledBorder(BORDER, ProGuardGUI.msg(string));
        jComponent.setBorder(border == null ? titledBorder : new CompoundBorder(titledBorder, border));
    }

    private JButton createPreviousButton(final TabbedPane tabbedPane) {
        JButton jButton = new JButton(ProGuardGUI.msg("previous"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                tabbedPane.previous();
            }
        });
        return jButton;
    }

    private JButton createNextButton(final TabbedPane tabbedPane) {
        JButton jButton = new JButton(ProGuardGUI.msg("next"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                tabbedPane.next();
            }
        });
        return jButton;
    }

    private JButton createBrowseButton(final JTextField jTextField, final String string) {
        JButton jButton = new JButton(ProGuardGUI.msg("browse"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                ProGuardGUI.this.fileChooser.setDialogTitle(string);
                ProGuardGUI.this.fileChooser.setSelectedFile(new File(jTextField.getText()));
                int n = ProGuardGUI.this.fileChooser.showDialog(ProGuardGUI.this, ProGuardGUI.msg("ok"));
                if (n == 0) {
                    jTextField.setText(ProGuardGUI.this.fileChooser.getSelectedFile().getPath());
                }
            }
        });
        return jButton;
    }

    protected JButton createOptimizationsButton(final JTextField jTextField) {
        final OptimizationsDialog optimizationsDialog = new OptimizationsDialog(this);
        JButton jButton = new JButton(ProGuardGUI.msg("select"));
        jButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent actionEvent) {
                optimizationsDialog.setFilter(jTextField.getText());
                int n = optimizationsDialog.showDialog();
                if (n == 0) {
                    jTextField.setText(optimizationsDialog.getFilter());
                }
            }
        });
        return jButton;
    }

    private void setCommonPreferredSize(List list) {
        JComponent jComponent;
        int n;
        Dimension dimension = null;
        for (n = 0; n < list.size(); ++n) {
            jComponent = (JComponent)list.get(n);
            Dimension dimension2 = jComponent.getPreferredSize();
            if (dimension != null && !(dimension2.getWidth() > dimension.getWidth())) continue;
            dimension = dimension2;
        }
        for (n = 0; n < list.size(); ++n) {
            jComponent = (JComponent)list.get(n);
            jComponent.setPreferredSize(dimension);
        }
    }

    private void setProGuardConfiguration(Configuration configuration) {
        String string;
        int n;
        this.programPanel.setClassPath(configuration.programJars);
        this.libraryPanel.setClassPath(configuration.libraryJars);
        for (n = 0; n < this.boilerplateKeep.length; ++n) {
            string = this.findMatchingKeepSpecifications(this.boilerplateKeep[n], configuration.keep);
            this.boilerplateKeepCheckBoxes[n].setSelected(string != null);
            this.boilerplateKeepTextFields[n].setText(string == null ? OPTIMIZATIONS_DEFAULT : string);
        }
        for (n = 0; n < this.boilerplateKeepNames.length; ++n) {
            string = this.findMatchingKeepSpecifications(this.boilerplateKeepNames[n], configuration.keep);
            this.boilerplateKeepNamesCheckBoxes[n].setSelected(string != null);
            this.boilerplateKeepNamesTextFields[n].setText(string == null ? OPTIMIZATIONS_DEFAULT : string);
        }
        this.additionalKeepPanel.setClassSpecifications(this.filteredKeepSpecifications(configuration.keep, false));
        this.additionalKeepNamesPanel.setClassSpecifications(this.filteredKeepSpecifications(configuration.keep, true));
        for (n = 0; n < this.boilerplateNoSideEffectMethods.length; ++n) {
            boolean bl = this.findClassSpecification(this.boilerplateNoSideEffectMethods[n], configuration.assumeNoSideEffects);
            this.boilerplateNoSideEffectMethodCheckBoxes[n].setSelected(bl);
        }
        this.additionalNoSideEffectsPanel.setClassSpecifications(configuration.assumeNoSideEffects);
        this.whyAreYouKeepingPanel.setClassSpecifications(configuration.whyAreYouKeeping);
        this.shrinkCheckBox.setSelected(configuration.shrink);
        this.printUsageCheckBox.setSelected(configuration.printUsage != null);
        this.optimizeCheckBox.setSelected(configuration.optimize);
        this.allowAccessModificationCheckBox.setSelected(configuration.allowAccessModification);
        this.mergeInterfacesAggressivelyCheckBox.setSelected(configuration.mergeInterfacesAggressively);
        this.optimizationPassesSpinner.getModel().setValue(new Integer(configuration.optimizationPasses));
        this.obfuscateCheckBox.setSelected(configuration.obfuscate);
        this.printMappingCheckBox.setSelected(configuration.printMapping != null);
        this.applyMappingCheckBox.setSelected(configuration.applyMapping != null);
        this.obfuscationDictionaryCheckBox.setSelected(configuration.obfuscationDictionary != null);
        this.classObfuscationDictionaryCheckBox.setSelected(configuration.classObfuscationDictionary != null);
        this.packageObfuscationDictionaryCheckBox.setSelected(configuration.packageObfuscationDictionary != null);
        this.overloadAggressivelyCheckBox.setSelected(configuration.overloadAggressively);
        this.useUniqueClassMemberNamesCheckBox.setSelected(configuration.useUniqueClassMemberNames);
        this.useMixedCaseClassNamesCheckBox.setSelected(configuration.useMixedCaseClassNames);
        this.keepPackageNamesCheckBox.setSelected(configuration.keepPackageNames != null);
        this.flattenPackageHierarchyCheckBox.setSelected(configuration.flattenPackageHierarchy != null);
        this.repackageClassesCheckBox.setSelected(configuration.repackageClasses != null);
        this.keepAttributesCheckBox.setSelected(configuration.keepAttributes != null);
        this.newSourceFileAttributeCheckBox.setSelected(configuration.newSourceFileAttribute != null);
        this.adaptClassStringsCheckBox.setSelected(configuration.adaptClassStrings != null);
        this.adaptResourceFileNamesCheckBox.setSelected(configuration.adaptResourceFileNames != null);
        this.adaptResourceFileContentsCheckBox.setSelected(configuration.adaptResourceFileContents != null);
        this.preverifyCheckBox.setSelected(configuration.preverify);
        this.microEditionCheckBox.setSelected(configuration.microEdition);
        this.targetCheckBox.setSelected(configuration.targetClassVersion != 0);
        this.verboseCheckBox.setSelected(configuration.verbose);
        this.noteCheckBox.setSelected(configuration.note == null || !configuration.note.isEmpty());
        this.warnCheckBox.setSelected(configuration.warn == null || !configuration.warn.isEmpty());
        this.ignoreWarningsCheckBox.setSelected(configuration.ignoreWarnings);
        this.skipNonPublicLibraryClassesCheckBox.setSelected(configuration.skipNonPublicLibraryClasses);
        this.skipNonPublicLibraryClassMembersCheckBox.setSelected(configuration.skipNonPublicLibraryClassMembers);
        this.keepDirectoriesCheckBox.setSelected(configuration.keepDirectories != null);
        this.forceProcessingCheckBox.setSelected(configuration.lastModified == Long.MAX_VALUE);
        this.printSeedsCheckBox.setSelected(configuration.printSeeds != null);
        this.printConfigurationCheckBox.setSelected(configuration.printConfiguration != null);
        this.dumpCheckBox.setSelected(configuration.dump != null);
        this.printUsageTextField.setText(ProGuardGUI.fileName(configuration.printUsage));
        this.optimizationsTextField.setText(configuration.optimizations == null ? OPTIMIZATIONS_DEFAULT : ListUtil.commaSeparatedString((List)configuration.optimizations));
        this.printMappingTextField.setText(ProGuardGUI.fileName(configuration.printMapping));
        this.applyMappingTextField.setText(ProGuardGUI.fileName(configuration.applyMapping));
        this.obfuscationDictionaryTextField.setText(ProGuardGUI.fileName(configuration.obfuscationDictionary));
        this.keepPackageNamesTextField.setText(configuration.keepPackageNames == null ? "" : ClassUtil.externalClassName((String)ListUtil.commaSeparatedString((List)configuration.keepPackageNames)));
        this.flattenPackageHierarchyTextField.setText(configuration.flattenPackageHierarchy);
        this.repackageClassesTextField.setText(configuration.repackageClasses);
        this.keepAttributesTextField.setText(configuration.keepAttributes == null ? KEEP_ATTRIBUTE_DEFAULT : ListUtil.commaSeparatedString((List)configuration.keepAttributes));
        this.newSourceFileAttributeTextField.setText(configuration.newSourceFileAttribute == null ? SOURCE_FILE_ATTRIBUTE_DEFAULT : configuration.newSourceFileAttribute);
        this.adaptClassStringsTextField.setText(configuration.adaptClassStrings == null ? "" : ClassUtil.externalClassName((String)ListUtil.commaSeparatedString((List)configuration.adaptClassStrings)));
        this.adaptResourceFileNamesTextField.setText(configuration.adaptResourceFileNames == null ? ADAPT_RESOURCE_FILE_NAMES_DEFAULT : ListUtil.commaSeparatedString((List)configuration.adaptResourceFileNames));
        this.adaptResourceFileContentsTextField.setText(configuration.adaptResourceFileContents == null ? ADAPT_RESOURCE_FILE_CONTENTS_DEFAULT : ListUtil.commaSeparatedString((List)configuration.adaptResourceFileContents));
        this.noteTextField.setText(ListUtil.commaSeparatedString((List)configuration.note));
        this.warnTextField.setText(ListUtil.commaSeparatedString((List)configuration.warn));
        this.keepDirectoriesTextField.setText(ListUtil.commaSeparatedString((List)configuration.keepDirectories));
        this.printSeedsTextField.setText(ProGuardGUI.fileName(configuration.printSeeds));
        this.printConfigurationTextField.setText(ProGuardGUI.fileName(configuration.printConfiguration));
        this.dumpTextField.setText(ProGuardGUI.fileName(configuration.dump));
        if (configuration.targetClassVersion != 0) {
            this.targetComboBox.setSelectedItem(ClassUtil.externalClassVersion((int)configuration.targetClassVersion));
        } else {
            this.targetComboBox.setSelectedIndex(this.targetComboBox.getItemCount() - 1);
        }
        if (configuration.printMapping != null) {
            this.reTraceMappingTextField.setText(ProGuardGUI.fileName(configuration.printMapping));
        }
    }

    private Configuration getProGuardConfiguration() {
        int n;
        List list;
        Configuration configuration = new Configuration();
        configuration.programJars = this.programPanel.getClassPath();
        configuration.libraryJars = this.libraryPanel.getClassPath();
        ArrayList<ClassSpecification> arrayList = new ArrayList<ClassSpecification>();
        List list2 = this.additionalKeepPanel.getClassSpecifications();
        if (list2 != null) {
            arrayList.addAll(list2);
        }
        if ((list = this.additionalKeepNamesPanel.getClassSpecifications()) != null) {
            arrayList.addAll(list);
        }
        for (n = 0; n < this.boilerplateKeep.length; ++n) {
            if (!this.boilerplateKeepCheckBoxes[n].isSelected()) continue;
            arrayList.add(this.classSpecification((ClassSpecification)this.boilerplateKeep[n], this.boilerplateKeepTextFields[n].getText()));
        }
        for (n = 0; n < this.boilerplateKeepNames.length; ++n) {
            if (!this.boilerplateKeepNamesCheckBoxes[n].isSelected()) continue;
            arrayList.add(this.classSpecification((ClassSpecification)this.boilerplateKeepNames[n], this.boilerplateKeepNamesTextFields[n].getText()));
        }
        if (arrayList.size() > 0) {
            configuration.keep = arrayList;
        }
        ArrayList<ClassSpecification> arrayList2 = new ArrayList<ClassSpecification>();
        for (int i = 0; i < this.boilerplateNoSideEffectMethods.length; ++i) {
            if (!this.boilerplateNoSideEffectMethodCheckBoxes[i].isSelected()) continue;
            arrayList2.add(this.boilerplateNoSideEffectMethods[i]);
        }
        List list3 = this.additionalNoSideEffectsPanel.getClassSpecifications();
        if (list3 != null) {
            arrayList2.addAll(list3);
        }
        if (arrayList2.size() > 0) {
            configuration.assumeNoSideEffects = arrayList2;
        }
        configuration.whyAreYouKeeping = this.whyAreYouKeepingPanel.getClassSpecifications();
        configuration.shrink = this.shrinkCheckBox.isSelected();
        configuration.printUsage = this.printUsageCheckBox.isSelected() ? new File(this.printUsageTextField.getText()) : null;
        configuration.optimize = this.optimizeCheckBox.isSelected();
        configuration.allowAccessModification = this.allowAccessModificationCheckBox.isSelected();
        configuration.mergeInterfacesAggressively = this.mergeInterfacesAggressivelyCheckBox.isSelected();
        configuration.optimizations = this.optimizationsTextField.getText().length() > 1 ? ListUtil.commaSeparatedList((String)this.optimizationsTextField.getText()) : null;
        configuration.optimizationPasses = ((SpinnerNumberModel)this.optimizationPassesSpinner.getModel()).getNumber().intValue();
        configuration.obfuscate = this.obfuscateCheckBox.isSelected();
        configuration.printMapping = this.printMappingCheckBox.isSelected() ? new File(this.printMappingTextField.getText()) : null;
        configuration.applyMapping = this.applyMappingCheckBox.isSelected() ? new File(this.applyMappingTextField.getText()) : null;
        configuration.obfuscationDictionary = this.obfuscationDictionaryCheckBox.isSelected() ? new File(this.obfuscationDictionaryTextField.getText()) : null;
        configuration.classObfuscationDictionary = this.classObfuscationDictionaryCheckBox.isSelected() ? new File(this.classObfuscationDictionaryTextField.getText()) : null;
        configuration.packageObfuscationDictionary = this.packageObfuscationDictionaryCheckBox.isSelected() ? new File(this.packageObfuscationDictionaryTextField.getText()) : null;
        configuration.overloadAggressively = this.overloadAggressivelyCheckBox.isSelected();
        configuration.useUniqueClassMemberNames = this.useUniqueClassMemberNamesCheckBox.isSelected();
        configuration.useMixedCaseClassNames = this.useMixedCaseClassNamesCheckBox.isSelected();
        configuration.keepPackageNames = this.keepPackageNamesCheckBox.isSelected() ? (this.keepPackageNamesTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.keepPackageNamesTextField.getText())) : new ArrayList()) : null;
        configuration.flattenPackageHierarchy = this.flattenPackageHierarchyCheckBox.isSelected() ? ClassUtil.internalClassName((String)this.flattenPackageHierarchyTextField.getText()) : null;
        configuration.repackageClasses = this.repackageClassesCheckBox.isSelected() ? ClassUtil.internalClassName((String)this.repackageClassesTextField.getText()) : null;
        configuration.keepAttributes = this.keepAttributesCheckBox.isSelected() ? ListUtil.commaSeparatedList((String)this.keepAttributesTextField.getText()) : null;
        String string = configuration.newSourceFileAttribute = this.newSourceFileAttributeCheckBox.isSelected() ? this.newSourceFileAttributeTextField.getText() : null;
        configuration.adaptClassStrings = this.adaptClassStringsCheckBox.isSelected() ? (this.adaptClassStringsTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.adaptClassStringsTextField.getText())) : new ArrayList()) : null;
        configuration.adaptResourceFileNames = this.adaptResourceFileNamesCheckBox.isSelected() ? ListUtil.commaSeparatedList((String)this.adaptResourceFileNamesTextField.getText()) : null;
        configuration.adaptResourceFileContents = this.adaptResourceFileContentsCheckBox.isSelected() ? ListUtil.commaSeparatedList((String)this.adaptResourceFileContentsTextField.getText()) : null;
        configuration.preverify = this.preverifyCheckBox.isSelected();
        configuration.microEdition = this.microEditionCheckBox.isSelected();
        configuration.targetClassVersion = this.targetCheckBox.isSelected() ? ClassUtil.internalClassVersion((String)this.targetComboBox.getSelectedItem().toString()) : 0;
        configuration.verbose = this.verboseCheckBox.isSelected();
        List list4 = this.noteCheckBox.isSelected() ? (this.noteTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.noteTextField.getText())) : null) : (configuration.note = new ArrayList());
        configuration.warn = this.warnCheckBox.isSelected() ? (this.warnTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.warnTextField.getText())) : null) : new ArrayList();
        configuration.ignoreWarnings = this.ignoreWarningsCheckBox.isSelected();
        configuration.skipNonPublicLibraryClasses = this.skipNonPublicLibraryClassesCheckBox.isSelected();
        configuration.skipNonPublicLibraryClassMembers = this.skipNonPublicLibraryClassMembersCheckBox.isSelected();
        configuration.keepDirectories = this.keepDirectoriesCheckBox.isSelected() ? (this.keepDirectoriesTextField.getText().length() > 0 ? ListUtil.commaSeparatedList((String)ClassUtil.internalClassName((String)this.keepDirectoriesTextField.getText())) : new ArrayList()) : null;
        configuration.lastModified = this.forceProcessingCheckBox.isSelected() ? Long.MAX_VALUE : System.currentTimeMillis();
        configuration.printSeeds = this.printSeedsCheckBox.isSelected() ? new File(this.printSeedsTextField.getText()) : null;
        configuration.printConfiguration = this.printConfigurationCheckBox.isSelected() ? new File(this.printConfigurationTextField.getText()) : null;
        configuration.dump = this.dumpCheckBox.isSelected() ? new File(this.dumpTextField.getText()) : null;
        return configuration;
    }

    private boolean findClassSpecification(ClassSpecification classSpecification, List list) {
        if (list == null) {
            return false;
        }
        for (int i = 0; i < list.size(); ++i) {
            if (!classSpecification.equals(list.get(i))) continue;
            list.remove(i);
            return true;
        }
        return false;
    }

    private List filteredKeepSpecifications(List list, boolean bl) {
        ArrayList<KeepClassSpecification> arrayList = new ArrayList<KeepClassSpecification>();
        for (int i = 0; i < list.size(); ++i) {
            KeepClassSpecification keepClassSpecification = (KeepClassSpecification)list.get(i);
            if (keepClassSpecification.allowShrinking != bl) continue;
            arrayList.add(keepClassSpecification);
        }
        return arrayList;
    }

    private String findMatchingKeepSpecifications(KeepClassSpecification keepClassSpecification, List list) {
        if (list == null) {
            return null;
        }
        StringBuffer stringBuffer = null;
        for (int i = 0; i < list.size(); ++i) {
            String string;
            KeepClassSpecification keepClassSpecification2 = (KeepClassSpecification)list.get(i);
            keepClassSpecification.className = string = keepClassSpecification2.className;
            if (!keepClassSpecification.equals((Object)keepClassSpecification2)) continue;
            if (stringBuffer == null) {
                stringBuffer = new StringBuffer();
            } else {
                stringBuffer.append(',');
            }
            stringBuffer.append(string == null ? OPTIMIZATIONS_DEFAULT : ClassUtil.externalClassName((String)string));
            list.remove(i--);
        }
        return stringBuffer == null ? null : stringBuffer.toString();
    }

    private ClassSpecification classSpecification(ClassSpecification classSpecification, String string) {
        ClassSpecification classSpecification2 = (ClassSpecification)classSpecification.clone();
        classSpecification2.className = string.equals("") || string.equals(OPTIMIZATIONS_DEFAULT) ? null : ClassUtil.internalClassName((String)string);
        return classSpecification2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(File file) {
        this.configurationChooser.setSelectedFile(file.getAbsoluteFile());
        this.fileChooser.setCurrentDirectory(file.getAbsoluteFile().getParentFile());
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(file);
            Configuration configuration = new Configuration();
            try {
                configurationParser.parse(configuration);
                this.setProGuardConfiguration(configuration);
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantParseConfigurationFile", file.getPath()), ProGuardGUI.msg("warning"), 0);
            }
            finally {
                configurationParser.close();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenConfigurationFile", file.getPath()), ProGuardGUI.msg("warning"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadConfiguration(URL uRL) {
        try {
            ConfigurationParser configurationParser = new ConfigurationParser(uRL);
            Configuration configuration = new Configuration();
            try {
                configurationParser.parse(configuration);
                this.setProGuardConfiguration(configuration);
            }
            catch (ParseException parseException) {
                JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantParseConfigurationFile", uRL), ProGuardGUI.msg("warning"), 0);
            }
            finally {
                configurationParser.close();
            }
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenConfigurationFile", uRL), ProGuardGUI.msg("warning"), 0);
        }
    }

    private void saveConfiguration(File file) {
        try {
            ConfigurationWriter configurationWriter = new ConfigurationWriter(file);
            configurationWriter.write(this.getProGuardConfiguration());
            configurationWriter.close();
        }
        catch (Exception exception) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantSaveConfigurationFile", file.getPath()), ProGuardGUI.msg("warning"), 0);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadStackTrace(String string) {
        try {
            StringBuffer stringBuffer = new StringBuffer(1024);
            BufferedReader bufferedReader = new BufferedReader(new FileReader(string));
            try {
                int n;
                while ((n = ((Reader)bufferedReader).read()) >= 0) {
                    stringBuffer.append(n);
                }
            }
            finally {
                ((Reader)bufferedReader).close();
            }
            this.stackTraceTextArea.setText(stringBuffer.toString());
        }
        catch (IOException iOException) {
            JOptionPane.showMessageDialog(this.getContentPane(), this.msg("cantOpenStackTraceFile", string), ProGuardGUI.msg("warning"), 0);
        }
    }

    private static String fileName(File file) {
        return file == null ? "" : file.getAbsolutePath();
    }

    private static JComponent tip(JComponent jComponent, String string) {
        jComponent.setToolTipText(ProGuardGUI.msg(string));
        return jComponent;
    }

    private static String msg(String string) {
        return GUIResources.getMessage(string);
    }

    private String msg(String string, Object object) {
        return GUIResources.getMessage(string, new Object[]{object});
    }

    public static void main(final String[] stringArray) {
        try {
            SwingUtil.invokeAndWait(new Runnable(){

                public void run() {
                    ProGuardGUI proGuardGUI = new ProGuardGUI();
                    proGuardGUI.pack();
                    Dimension dimension = Toolkit.getDefaultToolkit().getScreenSize();
                    Dimension dimension2 = proGuardGUI.getSize();
                    proGuardGUI.setLocation((dimension.width - dimension2.width) / 2, (dimension.height - dimension2.height) / 2);
                    proGuardGUI.show();
                    int n = 0;
                    if (n < stringArray.length && ProGuardGUI.NO_SPLASH_OPTION.startsWith(stringArray[n])) {
                        proGuardGUI.skipSplash();
                        ++n;
                    } else {
                        proGuardGUI.startSplash();
                    }
                    if (n < stringArray.length) {
                        proGuardGUI.loadConfiguration(new File(stringArray[n]));
                        ++n;
                    }
                    if (n < stringArray.length) {
                        System.out.println(proGuardGUI.getClass().getName() + ": ignoring extra arguments [" + stringArray[n] + "...]");
                    }
                }
            });
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private class MyReTraceActionListener
    implements ActionListener {
        private MyReTraceActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!systemOutRedirected) {
                systemOutRedirected = true;
                boolean bl = ProGuardGUI.this.reTraceVerboseCheckBox.isSelected();
                File file = new File(ProGuardGUI.this.reTraceMappingTextField.getText());
                String string = ProGuardGUI.this.stackTraceTextArea.getText();
                ReTraceRunnable reTraceRunnable = new ReTraceRunnable(ProGuardGUI.this.reTraceTextArea, bl, file, string);
                reTraceRunnable.run();
            }
        }
    }

    private class MyLoadStackTraceActionListener
    implements ActionListener {
        private MyLoadStackTraceActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProGuardGUI.this.fileChooser.setDialogTitle(ProGuardGUI.msg("selectStackTraceFile"));
            ProGuardGUI.this.fileChooser.setSelectedFile(null);
            int n = ProGuardGUI.this.fileChooser.showOpenDialog(ProGuardGUI.this);
            if (n == 0) {
                File file = ProGuardGUI.this.fileChooser.getSelectedFile();
                String string = file.getPath();
                ProGuardGUI.this.loadStackTrace(string);
            }
        }
    }

    private class MyProcessActionListener
    implements ActionListener {
        private MyProcessActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (!systemOutRedirected) {
                systemOutRedirected = true;
                File file = ProGuardGUI.this.configurationChooser.getSelectedFile();
                String string = file != null ? file.getName() : ProGuardGUI.msg("sampleConfigurationFileName");
                Thread thread = new Thread(new ProGuardRunnable(ProGuardGUI.this.consoleTextArea, ProGuardGUI.this.getProGuardConfiguration(), string));
                thread.start();
            }
        }
    }

    private class MyViewConfigurationActionListener
    implements ActionListener {
        private MyViewConfigurationActionListener() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void actionPerformed(ActionEvent actionEvent) {
            if (!systemOutRedirected) {
                ProGuardGUI.this.consoleTextArea.setText("");
                TextAreaOutputStream textAreaOutputStream = new TextAreaOutputStream(ProGuardGUI.this.consoleTextArea);
                try {
                    ConfigurationWriter configurationWriter = new ConfigurationWriter((OutputStream)textAreaOutputStream);
                    try {
                        configurationWriter.write(ProGuardGUI.this.getProGuardConfiguration());
                    }
                    finally {
                        configurationWriter.close();
                    }
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ProGuardGUI.this.consoleTextArea.setCaretPosition(0);
            }
        }
    }

    private class MySaveConfigurationActionListener
    implements ActionListener {
        private MySaveConfigurationActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProGuardGUI.this.configurationChooser.setDialogTitle(ProGuardGUI.msg("saveConfigurationFile"));
            int n = ProGuardGUI.this.configurationChooser.showSaveDialog(ProGuardGUI.this);
            if (n == 0) {
                ProGuardGUI.this.saveConfiguration(ProGuardGUI.this.configurationChooser.getSelectedFile());
            }
        }
    }

    private class MyLoadConfigurationActionListener
    implements ActionListener {
        private MyLoadConfigurationActionListener() {
        }

        public void actionPerformed(ActionEvent actionEvent) {
            ProGuardGUI.this.configurationChooser.setDialogTitle(ProGuardGUI.msg("selectConfigurationFile"));
            int n = ProGuardGUI.this.configurationChooser.showOpenDialog(ProGuardGUI.this);
            if (n == 0) {
                ProGuardGUI.this.loadConfiguration(ProGuardGUI.this.configurationChooser.getSelectedFile());
            }
        }
    }
}

