/*
 * Decompiled with CFR 0.152.
 */
package gnu.io;

import gnu.io.PortInUseException;
import gnu.io.SerialPort;
import gnu.io.SerialPortEvent;
import gnu.io.SerialPortEventListener;
import gnu.io.UnsupportedCommOperationException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.TooManyListenersException;

final class RXTXPort
extends SerialPort {
    private static boolean debug = false;
    private static boolean debug_verbose = false;
    private int fd = 0;
    int pid = 0;
    static boolean dsrFlag;
    private final SerialOutputStream out = new SerialOutputStream();
    private final SerialInputStream in = new SerialInputStream();
    private int speed = 9600;
    private int dataBits = 8;
    private int stopBits = 1;
    private int parity = 0;
    private int flowmode = 0;
    private int timeout = 0;
    private int threshold = 0;
    private int InputBuffer = 0;
    private int OutputBuffer = 0;
    private SerialPortEventListener SPEventListener;
    private MonitorThread monThread;
    boolean monThreadisInterrupted = true;
    boolean MonitorThreadLock = true;

    private static native void Initialize();

    public RXTXPort(String string) throws PortInUseException {
        if (debug) {
            System.out.println("RXTXPort:RXTXPort(" + string + ")");
        }
        this.fd = this.open(string);
        this.name = string;
        if (debug) {
            System.out.println("RXTXPort:RXTXPort(" + string + ") fd = " + this.fd);
        }
    }

    private synchronized native int open(String var1) throws PortInUseException;

    public OutputStream getOutputStream() {
        return this.out;
    }

    public InputStream getInputStream() {
        return this.in;
    }

    public synchronized void setSerialPortParams(int n, int n2, int n3, int n4) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:setSerialPortParams(" + n + " " + n2 + " " + n3 + " " + n4 + ")");
        }
        this.nativeSetSerialPortParams(n, n2, n3, n4);
        this.speed = n;
        this.dataBits = n3 == 3 ? 5 : n2;
        this.stopBits = n3;
        this.parity = n4;
    }

    private native void nativeSetSerialPortParams(int var1, int var2, int var3, int var4) throws UnsupportedCommOperationException;

    public int getBaudRate() {
        return this.speed;
    }

    public int getDataBits() {
        return this.dataBits;
    }

    public int getStopBits() {
        return this.stopBits;
    }

    public int getParity() {
        return this.parity;
    }

    public void setFlowControlMode(int n) {
        if (debug) {
            System.out.println("RXTXPort:setFlowControlMode()");
        }
        try {
            this.setflowcontrol(n);
        }
        catch (IOException iOException) {
            iOException.printStackTrace();
            return;
        }
        this.flowmode = n;
    }

    public int getFlowControlMode() {
        return this.flowmode;
    }

    native void setflowcontrol(int var1) throws IOException;

    public void enableReceiveFraming(int n) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("RXTXPort:enableReceiveFramming()");
        }
        throw new UnsupportedCommOperationException("Not supported");
    }

    public void disableReceiveFraming() {
        if (debug) {
            System.out.println("RXTXPort:disableReceiveFramming()");
        }
    }

    public boolean isReceiveFramingEnabled() {
        if (debug) {
            System.out.println("RXTXPort:isReceiveFrammingEnabled()");
        }
        return false;
    }

    public int getReceiveFramingByte() {
        if (debug) {
            System.out.println("RXTXPort:getReceiveFrammingByte()");
        }
        return 0;
    }

    public native int NativegetReceiveTimeout();

    public native boolean NativeisReceiveTimeoutEnabled();

    public native void NativeEnableReceiveTimeoutThreshold(int var1, int var2, int var3);

    public void disableReceiveTimeout() {
        if (debug) {
            System.out.println("RXTXPort:disableReceiveTimeout()");
        }
        this.enableReceiveTimeout(0);
    }

    public void enableReceiveTimeout(int n) {
        if (debug) {
            System.out.println("RXTXPort:enableReceiveTimeout()");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative timeout value");
        }
        this.timeout = n;
        this.NativeEnableReceiveTimeoutThreshold(n, this.threshold, this.InputBuffer);
    }

    public boolean isReceiveTimeoutEnabled() {
        if (debug) {
            System.out.println("RXTXPort:isReceiveTimeoutEnabled()");
        }
        return this.NativeisReceiveTimeoutEnabled();
    }

    public int getReceiveTimeout() {
        if (debug) {
            System.out.println("RXTXPort:getReceiveTimeout()");
        }
        return this.NativegetReceiveTimeout();
    }

    public void enableReceiveThreshold(int n) {
        if (debug) {
            System.out.println("RXTXPort:enableReceiveThreshold()");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative threshold value");
        }
        this.threshold = n;
        this.NativeEnableReceiveTimeoutThreshold(this.timeout, this.threshold, this.InputBuffer);
    }

    public void disableReceiveThreshold() {
        if (debug) {
            System.out.println("RXTXPort:disableReceiveThreshold()");
        }
        this.enableReceiveThreshold(0);
    }

    public int getReceiveThreshold() {
        if (debug) {
            System.out.println("RXTXPort:getReceiveThreshold()");
        }
        return this.threshold;
    }

    public boolean isReceiveThresholdEnabled() {
        if (debug) {
            System.out.println("RXTXPort:isReceiveThresholdEnable()");
        }
        return this.threshold > 0;
    }

    public void setInputBufferSize(int n) {
        if (debug) {
            System.out.println("RXTXPort:setInputBufferSize( " + n + ")");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.InputBuffer = n;
    }

    public int getInputBufferSize() {
        if (debug) {
            System.out.println("RXTXPort:getInputBufferSize()");
        }
        return this.InputBuffer;
    }

    public void setOutputBufferSize(int n) {
        if (debug) {
            System.out.println("RXTXPort:setOutputBufferSize( " + n + ")");
        }
        if (n < 0) {
            throw new IllegalArgumentException("Unexpected negative buffer size value");
        }
        this.OutputBuffer = n;
    }

    public int getOutputBufferSize() {
        if (debug) {
            System.out.println("RXTXPort:getOutputBufferSize()");
        }
        return this.OutputBuffer;
    }

    public native boolean isDTR();

    public native void setDTR(boolean var1);

    public native void setRTS(boolean var1);

    private native void setDSR(boolean var1);

    public native boolean isCTS();

    public native boolean isDSR();

    public native boolean isCD();

    public native boolean isRI();

    public native boolean isRTS();

    public native void sendBreak(int var1);

    private native void writeByte(int var1) throws IOException;

    private native void writeArray(byte[] var1, int var2, int var3) throws IOException;

    private native void nativeDrain() throws IOException;

    private native int nativeavailable() throws IOException;

    private native int readByte() throws IOException;

    private native int readArray(byte[] var1, int var2, int var3) throws IOException;

    native void eventLoop();

    private native void interruptEventLoop();

    public boolean checkMonitorThread() {
        if (debug) {
            System.out.println("RXTXPort:checkMonitorThread()");
        }
        if (this.monThread != null) {
            if (debug) {
                System.out.println("monThreadisInterrupted = " + this.monThreadisInterrupted);
            }
            return this.monThreadisInterrupted;
        }
        if (debug) {
            System.out.println("monThread is null ");
        }
        return true;
    }

    public boolean sendEvent(int n, boolean bl) {
        if (debug_verbose) {
            System.out.print("RXTXPort:sendEvent(");
        }
        if (this.fd == 0 || this.SPEventListener == null || this.monThread == null) {
            return true;
        }
        switch (n) {
            case 1: {
                if (!debug_verbose) break;
                System.out.println("DATA_AVAILABLE " + this.monThread.Data + ")");
                break;
            }
            case 2: {
                if (!debug_verbose) break;
                System.out.println("OUTPUT_BUF_EMPTY " + this.monThread.Output + ")");
                break;
            }
            case 3: {
                if (!debug_verbose) break;
                System.out.println("CTS " + this.monThread.Output + ")");
                break;
            }
            case 4: {
                if (!debug_verbose) break;
                System.out.println("DSR " + this.monThread.Output + ")");
                break;
            }
            case 5: {
                if (!debug_verbose) break;
                System.out.println("RI " + this.monThread.Output + ")");
                break;
            }
            case 6: {
                if (!debug_verbose) break;
                System.out.println("CD " + this.monThread.Output + ")");
                break;
            }
            case 7: {
                if (!debug_verbose) break;
                System.out.println("OE " + this.monThread.Output + ")");
                break;
            }
            case 8: {
                if (!debug_verbose) break;
                System.out.println("PE " + this.monThread.Output + ")");
                break;
            }
            case 9: {
                if (!debug_verbose) break;
                System.out.println("FE " + this.monThread.Output + ")");
                break;
            }
            case 10: {
                if (!debug_verbose) break;
                System.out.println("BI " + this.monThread.Output + ")");
                break;
            }
            default: {
                if (!debug_verbose) break;
                System.out.println("XXXXXXXXXXXXXX " + n + ")");
            }
        }
        switch (n) {
            case 1: {
                if (this.monThread.Data) break;
                return false;
            }
            case 2: {
                if (this.monThread.Output) break;
                return false;
            }
            case 3: {
                if (this.monThread.CTS) break;
                return false;
            }
            case 4: {
                if (this.monThread.DSR) break;
                return false;
            }
            case 5: {
                if (this.monThread.RI) break;
                return false;
            }
            case 6: {
                if (this.monThread.CD) break;
                return false;
            }
            case 7: {
                if (this.monThread.OE) break;
                return false;
            }
            case 8: {
                if (this.monThread.PE) break;
                return false;
            }
            case 9: {
                if (this.monThread.FE) break;
                return false;
            }
            case 10: {
                if (this.monThread.BI) break;
                return false;
            }
            default: {
                System.err.println("unknown event: " + n);
                return false;
            }
        }
        SerialPortEvent serialPortEvent = new SerialPortEvent(this, n, !bl, bl);
        if (this.SPEventListener != null) {
            this.SPEventListener.serialEvent(serialPortEvent);
        }
        return this.fd == 0 || this.SPEventListener == null || this.monThread == null;
    }

    public void addEventListener(SerialPortEventListener serialPortEventListener) throws TooManyListenersException {
        this.MonitorThreadLock = true;
        if (debug) {
            System.out.println("RXTXPort:addEventListener()");
        }
        if (this.SPEventListener != null) {
            throw new TooManyListenersException();
        }
        this.SPEventListener = serialPortEventListener;
        if (debug) {
            System.out.println("RXTXPort:Interrupt=false");
        }
        this.monThread = new MonitorThread();
        this.monThread.start();
        while (this.MonitorThreadLock) {
            try {
                Thread.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void removeEventListener() {
        if (debug) {
            System.out.println("RXTXPort:removeEventListener()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        if (this.monThreadisInterrupted) {
            System.out.println("RXTXPort:removeEventListener() already interrupted");
            this.monThread = null;
            this.SPEventListener = null;
            Runtime.getRuntime().gc();
            this.MonitorThreadLock = false;
            return;
        }
        if (this.monThread != null && this.monThread.isAlive()) {
            if (debug) {
                System.out.println("RXTXPort:Interrupt=true");
            }
            this.monThreadisInterrupted = true;
            this.interruptEventLoop();
            try {
                this.monThread.join(1000L);
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
            while (this.monThread.isAlive()) {
                if (debug) {
                    System.out.println("MonThread is still alive!");
                }
                try {
                    this.monThread.join(1000L);
                    Thread.sleep(1000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                this.monThread.stop();
            }
        }
        this.monThread = null;
        this.SPEventListener = null;
        Runtime.getRuntime().gc();
        this.MonitorThreadLock = false;
    }

    private void waitForTheNativeCodeSilly() {
        while (this.MonitorThreadLock) {
            try {
                Thread.sleep(2L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private native void nativeSetEventFlag(int var1, int var2, boolean var3);

    public void notifyOnDataAvailable(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnDataAvailable()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 1, bl);
        this.monThread.Data = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOutputEmpty(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnOutputEmpty()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 2, bl);
        this.monThread.Output = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCTS(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnCTS()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 3, bl);
        this.monThread.CTS = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnDSR(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnDSR()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 4, bl);
        this.monThread.DSR = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnRingIndicator(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnRingIndicator()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 5, bl);
        this.monThread.RI = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnCarrierDetect(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnCarrierDetect()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 6, bl);
        this.monThread.CD = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnOverrunError(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnOverrunError()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 7, bl);
        this.monThread.OE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnParityError(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnParityError()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 8, bl);
        this.monThread.PE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnFramingError(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnFramingError()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 9, bl);
        this.monThread.FE = bl;
        this.MonitorThreadLock = false;
    }

    public void notifyOnBreakInterrupt(boolean bl) {
        if (debug) {
            System.out.println("RXTXPort:notifyOnBreakInterrupt()");
        }
        this.waitForTheNativeCodeSilly();
        this.MonitorThreadLock = true;
        this.nativeSetEventFlag(this.fd, 10, bl);
        this.monThread.BI = bl;
        this.MonitorThreadLock = false;
    }

    private native void nativeClose(String var1);

    public synchronized void close() {
        if (debug) {
            System.out.println("RXTXPort:close( " + this.name + " )");
        }
        if (this.fd <= 0) {
            System.out.println("RXTXPort:close detected bad File Descriptor");
            return;
        }
        this.setDTR(false);
        this.setDSR(false);
        this.nativeClose(this.name);
        super.close();
        if (!this.monThreadisInterrupted) {
            this.removeEventListener();
        }
        this.fd = 0;
        Runtime.getRuntime().gc();
    }

    protected void finalize() {
        if (debug) {
            System.out.println("RXTXPort:finalize()");
        }
        if (this.fd > 0) {
            this.close();
        }
    }

    public void setRcvFifoTrigger(int n) {
    }

    private native int nativeGetParityErrorChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetParityErrorChar(byte var1) throws UnsupportedCommOperationException;

    private native int nativeGetEndOfInputChar() throws UnsupportedCommOperationException;

    private native boolean nativeSetEndOfInputChar(byte var1) throws UnsupportedCommOperationException;

    private native boolean nativeSetUartType(String var1, boolean var2) throws UnsupportedCommOperationException;

    native String nativeGetUartType() throws UnsupportedCommOperationException;

    private native boolean nativeSetBaudBase(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetBaudBase() throws UnsupportedCommOperationException;

    private native boolean nativeSetDivisor(int var1) throws UnsupportedCommOperationException;

    private native int nativeGetDivisor() throws UnsupportedCommOperationException;

    private native boolean nativeSetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeGetLowLatency() throws UnsupportedCommOperationException;

    private native boolean nativeSetCallOutHangup(boolean var1) throws UnsupportedCommOperationException;

    private native boolean nativeGetCallOutHangup() throws UnsupportedCommOperationException;

    int getParityErrorChar() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("getParityErrorChar()");
        }
        int n = this.nativeGetParityErrorChar();
        if (debug) {
            System.out.println("getParityErrorChar() returns " + n);
        }
        return n;
    }

    boolean setParityErrorChar(byte by) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("setParityErrorChar(" + by + ")");
        }
        return this.nativeSetParityErrorChar(by);
    }

    int getEndOfInputChar() throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("getEndOfInputChar()");
        }
        int n = this.nativeGetEndOfInputChar();
        if (debug) {
            System.out.println("getEndOfInputChar() returns " + n);
        }
        return n;
    }

    boolean setEndOfInputChar(byte by) throws UnsupportedCommOperationException {
        if (debug) {
            System.out.println("setEndOfInputChar(" + by + ")");
        }
        return this.nativeSetEndOfInputChar(by);
    }

    public boolean setUARTType(String string, boolean bl) throws UnsupportedCommOperationException {
        return this.nativeSetUartType(string, bl);
    }

    public String getUARTType() throws UnsupportedCommOperationException {
        return this.nativeGetUartType();
    }

    public boolean setBaudBase(int n) throws UnsupportedCommOperationException {
        return this.nativeSetBaudBase(n);
    }

    public int getBaudBase() throws UnsupportedCommOperationException {
        return this.nativeGetBaudBase();
    }

    public boolean setDivisor(int n) throws UnsupportedCommOperationException {
        return this.nativeSetDivisor(n);
    }

    public int getDivisor() throws UnsupportedCommOperationException {
        return this.nativeGetDivisor();
    }

    public boolean setLowLatency() throws UnsupportedCommOperationException {
        return this.nativeSetLowLatency();
    }

    public boolean getLowLatency() throws UnsupportedCommOperationException {
        return this.nativeGetLowLatency();
    }

    public boolean setCallOutHangup(boolean bl) throws UnsupportedCommOperationException {
        return this.nativeSetCallOutHangup(bl);
    }

    public boolean getCallOutHangup() throws UnsupportedCommOperationException {
        return this.nativeGetCallOutHangup();
    }

    static {
        if (debug) {
            System.out.println("RXTXPort {}");
        }
        System.loadLibrary("Serial");
        RXTXPort.Initialize();
        dsrFlag = false;
    }

    class MonitorThread
    extends Thread {
        private volatile boolean CTS = false;
        private volatile boolean DSR = false;
        private volatile boolean RI = false;
        private volatile boolean CD = false;
        private volatile boolean OE = false;
        private volatile boolean PE = false;
        private volatile boolean FE = false;
        private volatile boolean BI = false;
        private volatile boolean Data = false;
        private volatile boolean Output = false;

        MonitorThread() {
            if (debug) {
                System.out.println("RXTXPort:MontitorThread:MonitorThread()");
            }
        }

        public void run() {
            if (debug) {
                System.out.println("RXTXPort:MontitorThread:run()");
            }
            RXTXPort.this.monThreadisInterrupted = false;
            RXTXPort.this.eventLoop();
            if (debug) {
                System.out.println("eventLoop() returned");
            }
        }

        protected void finalize() throws Throwable {
            if (debug) {
                System.out.println("MonitorThread finalizing");
            }
        }
    }

    class SerialInputStream
    extends InputStream {
        SerialInputStream() {
        }

        public int read() throws IOException {
            if (debug_verbose) {
                System.out.println("RXTXPort:SerialInputStream:read()");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            int n = RXTXPort.this.readByte();
            if (debug) {
                System.out.println("readByte= " + n);
            }
            return n;
        }

        public int read(byte[] byArray) throws IOException {
            if (debug_verbose) {
                System.out.println("RXTXPort:SerialInputStream:read(" + byArray.length + ")");
            }
            int n = this.read(byArray, 0, byArray.length);
            if (debug) {
                System.out.println("read = " + n);
            }
            return n;
        }

        public int read(byte[] byArray, int n, int n2) throws IOException {
            if (debug_verbose) {
                System.out.println("RXTXPort:SerialInputStream:read(" + byArray.length + " " + n + " " + n2 + ") ");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            if (byArray == null) {
                throw new NullPointerException();
            }
            if (n < 0 || n2 < 0 || n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException();
            }
            if (n2 == 0) {
                return 0;
            }
            int n3 = n2;
            n3 = RXTXPort.this.threshold == 0 ? (this.available() == 0 ? 1 : Math.min(n3, this.available())) : Math.min(n3, RXTXPort.this.threshold);
            int n4 = RXTXPort.this.readArray(byArray, n, n3);
            if (debug) {
                System.out.println("RXTXPort:SerialInputStream:read(" + byArray.length + " " + n + " " + n2 + ") = " + n4 + " bytes containing ");
            }
            return n4;
        }

        public int available() throws IOException {
            int n = RXTXPort.this.nativeavailable();
            if (debug_verbose && n > 0) {
                System.out.println("available() returning " + n);
            }
            return n;
        }
    }

    class SerialOutputStream
    extends OutputStream {
        SerialOutputStream() {
        }

        public void write(int n) throws IOException {
            if (debug_verbose) {
                System.out.println("RXTXPort:SerialOutputStream:write(int)");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            RXTXPort.this.writeByte(n);
        }

        public void write(byte[] byArray) throws IOException {
            if (debug_verbose) {
                System.out.println("Entering RXTXPort:SerialOutputStream:write(" + byArray.length + ") ");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            RXTXPort.this.writeArray(byArray, 0, byArray.length);
            if (debug) {
                System.out.println("Leaving RXTXPort:SerialOutputStream:write(" + byArray.length + ")");
            }
        }

        public void write(byte[] byArray, int n, int n2) throws IOException {
            if (n + n2 > byArray.length) {
                throw new IndexOutOfBoundsException("Invalid offset/length passed to read");
            }
            byte[] byArray2 = new byte[n2];
            System.arraycopy(byArray, n, byArray2, 0, n2);
            if (debug_verbose) {
                System.out.println("Entering RXTXPort:SerialOutputStream:write(" + byArray2.length + " " + n + " " + n2 + " " + ") ");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            RXTXPort.this.writeArray(byArray2, 0, n2);
            if (debug) {
                System.out.println("Leaving RXTXPort:SerialOutputStream:write(" + byArray2.length + " " + n + " " + n2 + " " + ") ");
            }
        }

        public void flush() throws IOException {
            if (debug) {
                System.out.println("RXTXPort:SerialOutputStream:flush() enter");
            }
            if (RXTXPort.this.fd == 0) {
                throw new IOException();
            }
            RXTXPort.this.nativeDrain();
            if (debug) {
                System.out.println("RXTXPort:SerialOutputStream:flush() leave");
            }
        }
    }
}

