/*
 * Decompiled with CFR 0.152.
 */
package helma.xmlrpc.fesi;

import FESI.Data.BuiltinFunctionObject;
import FESI.Data.ESNull;
import FESI.Data.ESObject;
import FESI.Data.ESString;
import FESI.Data.ESUndefined;
import FESI.Data.ESValue;
import FESI.Data.FunctionPrototype;
import FESI.Data.GlobalObject;
import FESI.Data.ObjectObject;
import FESI.Data.ObjectPrototype;
import FESI.Exceptions.EcmaScriptException;
import FESI.Extensions.Extension;
import FESI.Interpreter.Evaluator;
import helma.xmlrpc.XmlRpcClient;
import helma.xmlrpc.fesi.FesiRpcServer;
import helma.xmlrpc.fesi.FesiRpcUtil;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Vector;

public class FesiRpcExtension
extends Extension {
    Evaluator evaluator;
    ESObject op;

    public void initializeExtension(Evaluator evaluator) throws EcmaScriptException {
        this.evaluator = evaluator;
        GlobalObject globalObject = evaluator.getGlobalObject();
        FunctionPrototype functionPrototype = (FunctionPrototype)evaluator.getFunctionPrototype();
        this.op = evaluator.getObjectPrototype();
        globalObject.putHiddenProperty("Remote", (ESValue)new GlobalObjectRemote("Remote", evaluator, functionPrototype));
        globalObject.putHiddenProperty("RemoteServer", (ESValue)new GlobalObjectRemoteServer("RemoteServer", evaluator, functionPrototype));
    }

    class GlobalObjectRemote
    extends BuiltinFunctionObject {
        GlobalObjectRemote(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super((ESObject)functionPrototype, evaluator, string, 1);
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return this.doConstruct(eSObject, eSValueArray);
        }

        public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            ESRemote eSRemote = null;
            String string = null;
            String string2 = null;
            if (eSValueArray.length >= 1) {
                string = eSValueArray[0].toString();
            }
            if (eSValueArray.length >= 2) {
                string2 = eSValueArray[1].toString();
            }
            try {
                eSRemote = new ESRemote(FesiRpcExtension.this.op, ((ESObject)this).evaluator, string, string2);
            }
            catch (MalformedURLException malformedURLException) {
                throw new EcmaScriptException(malformedURLException.toString());
            }
            return eSRemote;
        }
    }

    class GlobalObjectRemoteServer
    extends BuiltinFunctionObject {
        GlobalObjectRemoteServer(String string, Evaluator evaluator, FunctionPrototype functionPrototype) {
            super((ESObject)functionPrototype, evaluator, string, 1);
        }

        public ESValue callFunction(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            return this.doConstruct(eSObject, eSValueArray);
        }

        public ESObject doConstruct(ESObject eSObject, ESValue[] eSValueArray) throws EcmaScriptException {
            FesiRpcServer fesiRpcServer = null;
            String string = null;
            if (eSValueArray.length < 1 || eSValueArray.length > 2) {
                throw new EcmaScriptException("Wrong number of arguments for constructor RemoteServer");
            }
            int n = eSValueArray[0].toInt32();
            if (eSValueArray.length == 2) {
                string = eSValueArray[1].toString();
            }
            try {
                fesiRpcServer = new FesiRpcServer(n, FesiRpcExtension.this.op, ((ESObject)this).evaluator);
                if (string != null) {
                    ((ESObject)this).evaluator.getGlobalObject().putProperty(string, (ESValue)fesiRpcServer, string.hashCode());
                }
            }
            catch (IOException iOException) {
                throw new EcmaScriptException(iOException.toString());
            }
            return fesiRpcServer;
        }
    }

    class ESRemote
    extends ObjectPrototype {
        URL url;
        String remoteObject;

        public ESRemote(ESObject eSObject, Evaluator evaluator, String string, String string2) throws MalformedURLException {
            super(eSObject, evaluator);
            this.url = new URL(string);
            this.remoteObject = string2;
        }

        public ESRemote(ESObject eSObject, Evaluator evaluator, URL uRL, String string) {
            super(eSObject, evaluator);
            this.url = uRL;
            this.remoteObject = string;
        }

        public ESValue doIndirectCall(Evaluator evaluator, ESObject eSObject, String string, ESValue[] eSValueArray) throws EcmaScriptException, NoSuchMethodException {
            Object object;
            XmlRpcClient xmlRpcClient = new XmlRpcClient(this.url);
            long l = System.currentTimeMillis();
            Object object2 = null;
            int n = eSValueArray.length;
            Vector<ObjectPrototype> vector = new Vector<ObjectPrototype>();
            int n2 = 0;
            while (n2 < n) {
                object = FesiRpcUtil.convertE2J(eSValueArray[n2]);
                vector.addElement((ObjectPrototype)object);
                ++n2;
            }
            object = ObjectObject.createObject((Evaluator)evaluator);
            try {
                String string2 = this.remoteObject == null ? string : String.valueOf(this.remoteObject) + "." + string;
                object2 = xmlRpcClient.execute(string2, vector);
                object.putProperty("error", (ESValue)ESNull.theNull, "error".hashCode());
                object.putProperty("result", FesiRpcUtil.convertJ2E(object2, ((ESObject)this).evaluator), "result".hashCode());
            }
            catch (Exception exception) {
                String string3 = exception.getMessage();
                if (string3 == null || string3.length() == 0) {
                    string3 = exception.toString();
                }
                object.putProperty("error", (ESValue)new ESString(string3), "error".hashCode());
                object.putProperty("result", (ESValue)ESNull.theNull, "result".hashCode());
            }
            return object;
        }

        public ESValue getProperty(String string, int n) throws EcmaScriptException {
            ESValue eSValue = super.getProperty(string, n);
            if (eSValue != ESUndefined.theUndefined && eSValue != ESNull.theNull) {
                return eSValue;
            }
            String string2 = this.remoteObject == null ? string : String.valueOf(this.remoteObject) + "." + string;
            return new ESRemote(FesiRpcExtension.this.op, ((ESObject)this).evaluator, this.url, string2);
        }
    }
}

