/*
 * Decompiled with CFR 0.152.
 */
package org.nltk.mallet;

import edu.umass.cs.mallet.base.fst.CRF4;
import edu.umass.cs.mallet.base.fst.SimpleTagger;
import edu.umass.cs.mallet.base.pipe.Pipe;
import edu.umass.cs.mallet.base.pipe.iterator.LineGroupIterator;
import edu.umass.cs.mallet.base.pipe.iterator.PipeInputIterator;
import edu.umass.cs.mallet.base.types.InstanceList;
import edu.umass.cs.mallet.base.types.Sequence;
import edu.umass.cs.mallet.base.util.CommandOption;
import edu.umass.cs.mallet.base.util.MalletLogger;
import java.io.FileReader;
import java.io.ObjectInputStream;
import java.io.Reader;
import java.util.logging.Logger;
import java.util.regex.Pattern;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;

public class RunCRF {
    private static Logger logger = MalletLogger.getLogger((String)RunCRF.class.getName());
    private static Pattern blankline = Pattern.compile("^\\s*$");
    private static final CommandOption.File modelFileOption = new CommandOption.File(SimpleTagger.class, "model-file", "FILENAME", true, null, "The filename for the model.", null);
    private static final CommandOption.File testFileOption = new CommandOption.File(RunCRF.class, "test-file", "FILENAME", true, null, "The filename for the testing data.", null);
    private static final CommandOption.List commandOptions = new CommandOption.List("Run the CRF4 tagger", new CommandOption[]{modelFileOption, testFileOption});

    private RunCRF() {
    }

    public static void main(String[] stringArray) throws Exception {
        Object var1_1 = null;
        FileReader fileReader = null;
        Object var3_3 = null;
        InstanceList instanceList = null;
        Pipe pipe = null;
        CRF4 cRF4 = null;
        boolean bl = false;
        int n = 16;
        int n2 = commandOptions.processOptions(stringArray);
        if (n2 != stringArray.length) {
            commandOptions.printUsage(true);
            throw new IllegalArgumentException("Unexpected arg " + stringArray[n2]);
        }
        if (RunCRF.testFileOption.value == null) {
            commandOptions.printUsage(true);
            throw new IllegalArgumentException("Expected --test-file FILE");
        }
        if (RunCRF.modelFileOption.value == null) {
            commandOptions.printUsage(true);
            throw new IllegalArgumentException("Expected --model-file MODEL");
        }
        ZipFile zipFile = new ZipFile(RunCRF.modelFileOption.value);
        ZipEntry zipEntry = zipFile.getEntry("crf-model.ser");
        ObjectInputStream objectInputStream = new ObjectInputStream(zipFile.getInputStream(zipEntry));
        cRF4 = (CRF4)objectInputStream.readObject();
        objectInputStream.close();
        pipe = cRF4.getInputPipe();
        pipe.setTargetProcessing(false);
        fileReader = new FileReader(RunCRF.testFileOption.value);
        instanceList = new InstanceList(pipe);
        instanceList.add((PipeInputIterator)new LineGroupIterator((Reader)fileReader, blankline, true));
        for (int i = 0; i < instanceList.size(); ++i) {
            Sequence sequence = (Sequence)instanceList.getInstance(i).getData();
            Sequence sequence2 = cRF4.transduce(sequence);
            if (sequence2.size() != sequence.size()) {
                throw new Exception("Failed to decode " + i + ", got" + sequence2);
            }
            for (int j = 0; j < sequence.size(); ++j) {
                System.out.println(sequence2.get(j).toString());
            }
            System.out.println();
        }
    }
}

